/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.property;

import java.awt.BasicStroke;
import org.jplot2d.env.PropertyInfo;
import org.jplot2d.swing.proptable.property.MainProperty;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.swing.proptable.property.PropertyDescriptorAdapter;
import org.jplot2d.swing.proptable.property.SubProperty;

public class BasicStrokeProperty
extends PropertyDescriptorAdapter<BasicStroke> {
    private Property<Float> spLineWidth;
    private Property<float[]> spDashArray;
    private Float lineWidth;
    private float[] dashArray;

    public BasicStrokeProperty(PropertyInfo descriptor) {
        super(descriptor);
        this.initSubProperties();
    }

    @Override
    public Property<?>[] getSubProperties() {
        return new Property[]{this.spLineWidth, this.spDashArray};
    }

    @Override
    public void readFromObject(Object object) {
        super.readFromObject(object);
        if (this.getValue() != null) {
            this.lineWidth = Float.valueOf(((BasicStroke)this.getValue()).getLineWidth());
            this.dashArray = ((BasicStroke)this.getValue()).getDashArray();
        }
    }

    private void updateValue() {
        BasicStroke v = (BasicStroke)this.getValue();
        if (this.lineWidth == null) {
            this.setValue(null);
        } else if (this.dashArray == null) {
            if (v == null) {
                this.setValue(new BasicStroke(this.lineWidth.floatValue()));
            } else {
                this.setValue(new BasicStroke(this.lineWidth.floatValue(), v.getEndCap(), v.getLineJoin(), v.getMiterLimit()));
            }
        } else if (v == null) {
            this.setValue(new BasicStroke(this.lineWidth.floatValue(), 2, 0, 10.0f));
        } else {
            this.setValue(new BasicStroke(this.lineWidth.floatValue(), v.getEndCap(), v.getLineJoin(), v.getMiterLimit(), this.dashArray, v.getDashPhase()));
        }
    }

    private void initSubProperties() {
        this.spLineWidth = new SubProperty<Float>((MainProperty)this){

            @Override
            public String getName() {
                return "LineWidth";
            }

            @Override
            public Class<Float> getType() {
                return Float.class;
            }

            @Override
            public Float getValue() {
                return BasicStrokeProperty.this.lineWidth;
            }

            @Override
            public void setValue(Float x) {
                BasicStrokeProperty.this.lineWidth = x;
                BasicStrokeProperty.this.updateValue();
            }
        };
        this.spDashArray = new SubProperty<float[]>((MainProperty)this){

            @Override
            public String getName() {
                return "DashArray";
            }

            @Override
            public Class<float[]> getType() {
                return float[].class;
            }

            @Override
            public float[] getValue() {
                return BasicStrokeProperty.this.dashArray;
            }

            @Override
            public void setValue(float[] y) {
                BasicStrokeProperty.access$202(BasicStrokeProperty.this, y);
                BasicStrokeProperty.this.updateValue();
            }
        };
    }

    static /* synthetic */ float[] access$202(BasicStrokeProperty x0, float[] x1) {
        x0.dashArray = x1;
        return x1;
    }
}

