/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.jplot2d.swing.proptable.editor.FormattedEditor;

public class FloatEditor
extends FormattedEditor {
    private static NumberFormat getFloatFormat() {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setNaN("NaN");
        format.setDecimalFormatSymbols(symbols);
        format.setMaximumFractionDigits(8);
        return format;
    }

    public FloatEditor() {
        super(FloatEditor.getFloatFormat());
    }

    @Override
    public Object getValue() {
        Object v = super.getValue();
        if (v instanceof Number) {
            return new Float(((Number)v).floatValue());
        }
        return v;
    }
}

