/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.jplot2d.swing.proptable.cellrenderer.ColorCellRenderer;
import org.jplot2d.swing.proptable.editor.AbstractPropertyEditor;
import org.jplot2d.swing.proptable.editor.ColorChooser;
import org.jplot2d.swing.proptable.editor.FixedButton;

public class ColorPropertyEditor
extends AbstractPropertyEditor<JPanel> {
    private ColorCellRenderer label;
    private JButton button;
    private Color color;

    public ColorPropertyEditor() {
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.getLabel(), "Center");
        ((JPanel)this.editor).add((Component)this.getButton(), "East");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPropertyEditor.this.selectColor();
            }
        });
        ((JPanel)this.editor).setOpaque(false);
    }

    private ColorCellRenderer getLabel() {
        if (this.label == null) {
            this.label = new ColorCellRenderer();
            this.label.setUI((LabelUI)UIManager.getUI(this.label));
            this.label.setOpaque(false);
        }
        return this.label;
    }

    private JButton getButton() {
        if (this.button == null) {
            this.button = new FixedButton();
        }
        return this.button;
    }

    @Override
    public Object getValue() {
        return this.color;
    }

    @Override
    public void setValue(Object value) {
        this.color = (Color)value;
        this.label.setValue(this.color);
    }

    protected void selectColor() {
        String title = "Pick a color";
        Color selectedColor = ColorChooser.showDialog(this.editor, title, this.color);
        if (selectedColor != null) {
            Color oldColor = this.color;
            this.setValue(selectedColor);
            this.firePropertyChange(oldColor, this.color);
        }
    }
}

