/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;

public class ColorChooser
extends JColorChooser {
    private static final long serialVersionUID = 1L;

    public ColorChooser() {
    }

    public ColorChooser(Color color) {
        super(color);
    }

    public ColorChooser(ColorSelectionModel model) {
        super(model);
    }

    @Override
    public void setChooserPanels(AbstractColorChooserPanel[] panels) {
        AbstractColorChooserPanel[] panels2 = panels;
        if (panels != null) {
            int numNeeded = 0;
            for (int i = 0; i < panels.length; ++i) {
                if (panels[i].getClass().getName().contains("DefaultHSBChooserPanel")) continue;
                ++numNeeded;
            }
            if (numNeeded < panels.length) {
                panels2 = new AbstractColorChooserPanel[numNeeded];
                int j = 0;
                for (int i = 0; i < panels.length; ++i) {
                    if (panels[i].getClass().getName().contains("DefaultHSBChooserPanel")) continue;
                    panels2[j++] = panels[i];
                }
            }
        }
        super.setChooserPanels(panels2);
    }

    public static Color showDialog(Component component, String title, Color initialColor) throws HeadlessException {
        ColorChooser pane = new ColorChooser(initialColor != null ? initialColor : Color.WHITE);
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = ColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.setVisible(true);
        return ok.getColor();
    }

    public static JDialog createDialog(Component c, String title, boolean modal, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        if (!(chooserPane instanceof ColorChooser)) {
            throw new IllegalArgumentException("Do not create a JColorChooser, use a ColorChooser!");
        }
        return JColorChooser.createDialog(c, title, modal, chooserPane, okListener, cancelListener);
    }

    static class ColorTracker
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        ColorChooser chooser;
        Color color;

        public ColorTracker(ColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

