/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.proptable.cellrenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.BasicStrokeCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.ColorCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.DigitsLimitableCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.Dimension2DCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.DimensionCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.DoubleArrayCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.DoubleCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.FloatArrayCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.FloatCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.FontCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.Insets2DCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.InsetsCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.ObjectCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.Point2DCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.PointCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.RangeCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.Rectangle2DCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.RectangleCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.StringArrayCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.StringCellRenderer;
import org.jplot2d.swing.proptable.cellrenderer.TableCellRendererFactory;
import org.jplot2d.swing.proptable.property.Property;
import org.jplot2d.util.Insets2D;
import org.jplot2d.util.Range;

public class TableCellRendererRegistry
implements TableCellRendererFactory {
    private Map<Class<?>, TableCellRenderer> typeRendererMap;
    private TableCellRenderer defaultCellRenderer = new StringCellRenderer();

    public TableCellRendererRegistry() {
        this.typeRendererMap = new HashMap();
        this.registerDefaults();
    }

    public void registerRenderer(Class<?> type, TableCellRenderer renderer) {
        this.typeRendererMap.put(type, renderer);
    }

    public void unregisterRenderer(Class<?> type) {
        this.typeRendererMap.remove(type);
    }

    @Override
    public TableCellRenderer createTableCellRenderer(Property<?> property) {
        TableCellRenderer result = this.typeRendererMap.get(property.getType());
        if (result == null && property.getType().isInterface()) {
            result = this.defaultCellRenderer;
        }
        if (result instanceof DigitsLimitableCellRenderer && property.getDisplayDigits() != 0) {
            ((DigitsLimitableCellRenderer)result).setDigitsLimit(property.getDisplayDigits());
        }
        return result;
    }

    public void registerDefaults() {
        this.typeRendererMap.clear();
        this.registerRenderer(Float.TYPE, new FloatCellRenderer());
        this.registerRenderer(Float.class, new FloatCellRenderer());
        this.registerRenderer(Double.TYPE, new DoubleCellRenderer());
        this.registerRenderer(Double.class, new DoubleCellRenderer());
        this.registerRenderer(Point.class, new PointCellRenderer());
        this.registerRenderer(Point2D.class, new Point2DCellRenderer());
        this.registerRenderer(Dimension.class, new DimensionCellRenderer());
        this.registerRenderer(Dimension2D.class, new Dimension2DCellRenderer());
        this.registerRenderer(Rectangle.class, new RectangleCellRenderer());
        this.registerRenderer(Rectangle2D.class, new Rectangle2DCellRenderer());
        this.registerRenderer(Insets.class, new InsetsCellRenderer());
        this.registerRenderer(Insets2D.class, new Insets2DCellRenderer());
        this.registerRenderer(Color.class, new ColorCellRenderer());
        this.registerRenderer(Font.class, new FontCellRenderer());
        this.registerRenderer(Range.class, new RangeCellRenderer());
        this.registerRenderer(BasicStroke.class, new BasicStrokeCellRenderer());
        this.registerRenderer(Object.class, new ObjectCellRenderer());
        this.registerRenderer(float[].class, new FloatArrayCellRenderer());
        this.registerRenderer(double[].class, new DoubleArrayCellRenderer());
        this.registerRenderer(String[].class, new StringArrayCellRenderer());
    }
}

