/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.swing.demo;

import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.LookupTable;
import org.jplot2d.element.Axis;
import org.jplot2d.element.ElementFactory;
import org.jplot2d.element.ImageGraph;
import org.jplot2d.element.Layer;
import org.jplot2d.element.Plot;
import org.jplot2d.element.RGBImageGraph;
import org.jplot2d.image.ColorMap;
import org.jplot2d.sizing.AutoPackSizeMode;
import org.jplot2d.swing.JPlot2DFrame;

public class ImageFloat2dDemo {
    public static void main(String[] args) {
        ImageFloat2dDemo.plot(0.5, null);
        ImageFloat2dDemo.plot(0.5, new RgbColormap());
        ImageFloat2dDemo.plotRGB();
    }

    public static void plot(double gain, ColorMap map) {
        Plot plot = ElementFactory.getInstance().createPlot();
        plot.setSizeMode(new AutoPackSizeMode());
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis xaxis = ElementFactory.getInstance().createAxis();
        xaxis.getTitle().setText("x axis");
        plot.addXAxis(xaxis);
        Axis yaxis = ElementFactory.getInstance().createAxis();
        yaxis.getTitle().setText("y axis");
        plot.addYAxis(yaxis);
        float[][] f2d = new float[1024][1024];
        for (int i = 0; i < 1024; ++i) {
            for (int j = 0; j < 1024; ++j) {
                f2d[i][j] = (float)(i + j & 0xFF) / 1024.0f;
            }
        }
        ImageGraph graph = ElementFactory.getInstance().createImageGraph(f2d);
        Layer layer0 = ElementFactory.getInstance().createLayer();
        layer0.addGraph(graph);
        plot.addLayer(layer0, xaxis, yaxis);
        graph.getMapping().setGain(gain);
        graph.getMapping().setColorMap(map);
        graph.setData(null);
    }

    public static void plotRGB() {
        Plot plot = ElementFactory.getInstance().createPlot();
        plot.setSizeMode(new AutoPackSizeMode());
        JPlot2DFrame frame = new JPlot2DFrame(plot);
        frame.setSize(640, 480);
        frame.setVisible(true);
        Axis xaxis = ElementFactory.getInstance().createAxis();
        xaxis.getTitle().setText("x axis");
        plot.addXAxis(xaxis);
        Axis yaxis = ElementFactory.getInstance().createAxis();
        yaxis.getTitle().setText("y axis");
        plot.addYAxis(yaxis);
        float[][] r2d = new float[][]{{0.0f, 1.0f}, {2.0f, 3.0f}};
        float[][] g2d = new float[][]{{3.0f, 0.0f}, {1.0f, 2.0f}};
        float[][] b2d = new float[][]{{2.0f, 3.0f}, {0.0f, 1.0f}};
        RGBImageGraph graph = ElementFactory.getInstance().createRGBImageGraph(r2d, g2d, b2d);
        Layer layer0 = ElementFactory.getInstance().createLayer();
        layer0.addGraph(graph);
        plot.addLayer(layer0, xaxis, yaxis);
        graph.setData(null);
    }

    public static class RgbColormap
    implements ColorMap {
        private LookupTable lut;

        public RgbColormap() {
            byte[] la = new byte[256];
            for (int i = 0; i < 256; ++i) {
                la[i] = (byte)i;
            }
            this.lut = new ByteLookupTable(0, new byte[][]{la, la, la});
        }

        @Override
        public int getInputBits() {
            return 8;
        }

        @Override
        public LookupTable getLookupTable() {
            return this.lut;
        }

        @Override
        public ColorModel getColorModel() {
            return new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
        }
    }
}

