/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.sizing;

import java.awt.geom.Dimension2D;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.sizing.SizeMode;
import org.jplot2d.util.DoubleDimension2D;

public class FixedSizeMode
extends SizeMode {
    private static final Dimension2D DEFAULT_SIZE = new DoubleDimension2D(640.0, 480.0);
    private final double width;
    private final double height;

    public FixedSizeMode() {
        this(DEFAULT_SIZE);
    }

    public FixedSizeMode(Dimension2D size) {
        super(false);
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public FixedSizeMode(double width, double height) {
        super(false);
        this.width = width;
        this.height = height;
    }

    @Override
    public SizeMode.Result update(PlotEx plot) {
        double scaleY;
        Dimension2D containerSize = plot.getContainerSize();
        double scaleX = containerSize.getWidth() / this.width;
        double scale = scaleX < (scaleY = containerSize.getHeight() / this.height) ? scaleX : scaleY;
        return new SizeMode.Result(this.width, this.height, scale);
    }

    public String toString() {
        return "Fixed size " + this.width + "x" + this.height;
    }
}

