/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jplot2d.renderer.BufferedImageFactory;
import org.jplot2d.renderer.ImageExporter;
import org.jplot2d.renderer.ImageFactory;

public class PngFileExporter
extends ImageExporter {
    private static final ImageFactory INT_RGB_IMAGEFACTORY = new BufferedImageFactory(1, Color.WHITE);
    private final File file;

    public PngFileExporter(String pathname) {
        this(new File(pathname));
    }

    public PngFileExporter(File file) {
        this(INT_RGB_IMAGEFACTORY, file);
    }

    public PngFileExporter(ImageFactory imageFactory, File file) {
        super(imageFactory);
        this.file = file;
    }

    @Override
    protected void fireRenderingFinished(long sn, BufferedImage img) {
        super.fireRenderingFinished(sn, img);
        try {
            ImageIO.write((RenderedImage)img, "PNG", this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Png file I/O exception", e);
        }
    }
}

