/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jplot2d.element.impl.ComponentEx;

public class ImageAssemblyInfo {
    private final Map<ComponentEx, InfoItem> map = new LinkedHashMap<ComponentEx, InfoItem>();

    public boolean contains(ComponentEx comp) {
        return this.map.containsKey(comp);
    }

    public Set<ComponentEx> componentSet() {
        return this.map.keySet();
    }

    public Rectangle getBounds(ComponentEx comp) {
        return this.map.get(comp).bounds;
    }

    public Future<BufferedImage> getFuture(ComponentEx comp) {
        return this.map.get(comp).future;
    }

    public void put(ComponentEx comp, Rectangle bounds, Future<BufferedImage> future) {
        this.map.put(comp, new InfoItem(bounds, future));
    }

    private static class InfoItem {
        private Rectangle bounds;
        private Future<BufferedImage> future;

        private InfoItem(Rectangle bounds, Future<BufferedImage> future) {
            this.bounds = bounds;
            this.future = future;
        }
    }
}

