/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.Renderer;

public class EpsExporter
extends Renderer {
    private final OutputStream os;

    public EpsExporter(String pathname) throws FileNotFoundException {
        this(new File(pathname));
    }

    public EpsExporter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public EpsExporter(OutputStream out) {
        this.os = new BufferedOutputStream(out);
    }

    @Override
    public void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        Dimension size = EpsExporter.getDeviceBounds(comp).getSize();
        EPSDocumentGraphics2D g = new EPSDocumentGraphics2D(false);
        g.setGraphicContext(new GraphicContext());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g.setupDocument(this.os, size.width, size.height);
        }
        catch (IOException e) {
            throw new RuntimeException("Error exporting EPS", e);
        }
        for (CacheableBlock cb : cacheBlockList) {
            List<ComponentEx> sublist = cb.getSubcomps();
            for (ComponentEx subcomp : sublist) {
                subcomp.draw((Graphics2D)g);
            }
        }
        try {
            g.finish();
        }
        catch (IOException e) {
            throw new RuntimeException("Error exporting EPS", e);
        }
    }
}

