/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.renderer;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.renderer.CacheableBlock;
import org.jplot2d.renderer.ImageAssemblyInfo;
import org.jplot2d.renderer.ImageFactory;
import org.jplot2d.renderer.ImageRenderer;
import org.jplot2d.renderer.Renderer;

public class AsyncImageRenderer
extends ImageRenderer {
    private volatile RendererCancelPolicy cancelPolicy = RendererCancelPolicy.CANCEL_BEFORE_EXEC_NEWER;
    private Object renderLock = new Object();
    private final Queue<AsyncImageRendererTask> renderTaskQueue = new LinkedList<AsyncImageRendererTask>();

    public AsyncImageRenderer(ImageFactory imageFactory) {
        super(imageFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void render(ComponentEx comp, List<CacheableBlock> cacheBlockList) {
        CancelableRendererCallable callable;
        Rectangle bounds = AsyncImageRenderer.getDeviceBounds(comp);
        if (cacheBlockList.size() == 1) {
            callable = new SingleRendererCallable(this.fsn++, bounds, cacheBlockList.get(0));
        } else {
            ImageAssemblyInfo ainfo = this.runCompRender(this.executor, cacheBlockList);
            callable = new RenderAssemblyCallable(this.fsn++, bounds, ainfo);
        }
        Object object = this.renderLock;
        synchronized (object) {
            AsyncImageRendererTask task = new AsyncImageRendererTask(callable);
            if (this.cancelPolicy == RendererCancelPolicy.CANCEL_BEFORE_EXEC_NEWER) {
                AsyncImageRendererTask rtask;
                while ((rtask = this.renderTaskQueue.poll()) != null) {
                    if (!rtask.cancel(true)) continue;
                    logger.trace("Render task {} to be exec. The render task {} is cancelled.", (Object)task.getSN(), (Object)rtask.getSN());
                }
            }
            this.renderTaskQueue.offer(task);
            this.executor.execute(task);
        }
    }

    public RendererCancelPolicy getRendererCancelPolicy() {
        return this.cancelPolicy;
    }

    public void setRendererCancelPolicy(RendererCancelPolicy policy) {
        this.cancelPolicy = policy;
    }

    public static enum RendererCancelPolicy {
        CANCEL_BEFORE_EXEC_NEWER,
        CANCEL_AFTER_NEWER_DONE,
        NO_CANCEL;

    }

    private final class AsyncImageRendererTask
    extends FutureTask<BufferedImage> {
        private final CancelableRendererCallable callable;

        public AsyncImageRendererTask(CancelableRendererCallable callable) {
            super(callable);
            this.callable = callable;
        }

        public long getSN() {
            return this.callable.sn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void done() {
            if (this.isCancelled()) {
                this.callable.cancel();
                return;
            }
            BufferedImage result = null;
            try {
                result = (BufferedImage)this.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                Renderer.logger.warn("Renderer exception, drop R." + this.getSN(), (Throwable)e);
            }
            AsyncImageRenderer.this.fireRenderingFinished(this.getSN(), result);
            if (AsyncImageRenderer.this.cancelPolicy == RendererCancelPolicy.CANCEL_AFTER_NEWER_DONE) {
                Object object = AsyncImageRenderer.this.renderLock;
                synchronized (object) {
                    AsyncImageRendererTask head = (AsyncImageRendererTask)AsyncImageRenderer.this.renderTaskQueue.peek();
                    if (head != null && head.getSN() <= this.getSN()) {
                        AsyncImageRendererTask renderer;
                        while ((renderer = (AsyncImageRendererTask)AsyncImageRenderer.this.renderTaskQueue.poll()).getSN() != this.getSN()) {
                            if (renderer.getSN() >= this.getSN() || !renderer.cancel(true)) continue;
                            Renderer.logger.trace("Renderer {} finished. Cancel the old renderer {}", (Object)this.getSN(), (Object)renderer.getSN());
                        }
                    }
                }
            }
        }
    }

    private final class RenderAssemblyCallable
    extends CancelableRendererCallable {
        private final ImageAssemblyInfo ainfo;

        private RenderAssemblyCallable(long sn, Rectangle bounds, ImageAssemblyInfo ainfo) {
            super(sn, bounds);
            this.ainfo = ainfo;
        }

        @Override
        public BufferedImage call() throws Exception {
            return AsyncImageRenderer.this.assembleResult(this.sn, this.bounds, this.ainfo);
        }

        @Override
        public void cancel() {
            for (ComponentEx comp : this.ainfo.componentSet()) {
                if (AsyncImageRenderer.this.isFutureCached(comp, this.ainfo.getFuture(comp))) continue;
                this.ainfo.getFuture(comp).cancel(true);
            }
        }
    }

    private final class SingleRendererCallable
    extends CancelableRendererCallable {
        private final CacheableBlock cacheableBlock;

        public SingleRendererCallable(long sn, Rectangle bounds, CacheableBlock cacheableBlock) {
            super(sn, bounds);
            this.cacheableBlock = cacheableBlock;
        }

        @Override
        public BufferedImage call() throws Exception {
            return AsyncImageRenderer.this.renderCacheableBlock(this.bounds, this.cacheableBlock);
        }

        @Override
        public void cancel() {
        }
    }

    private abstract class CancelableRendererCallable
    implements Callable<BufferedImage> {
        protected final long sn;
        protected final Rectangle bounds;

        public CancelableRendererCallable(long sn, Rectangle bounds) {
            this.sn = sn;
            this.bounds = bounds;
        }

        public abstract void cancel();
    }
}

