/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.layout;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.layout.GridCellGeom;
import org.jplot2d.layout.GridCellInsets;
import org.jplot2d.layout.GridConstraint;
import org.jplot2d.layout.SimpleLayoutDirector;
import org.jplot2d.util.DoubleDimension2D;
import org.jplot2d.util.SparseDoubleArray;

public class GridLayoutDirector
extends SimpleLayoutDirector {
    private final double hgap;
    private final double vgap;
    private Map<PlotEx, GridCellGeom> plotsPreferredContentsGeomMap = new HashMap<PlotEx, GridCellGeom>();
    private Map<PlotEx, GridCellInsets> plotsMarginGeomMap = new HashMap<PlotEx, GridCellInsets>();

    protected static Map<PlotEx, SimpleLayoutDirector.AxesInPlot> getSubplotAxisMap(PlotEx[] subplots) {
        HashMap<PlotEx, SimpleLayoutDirector.AxesInPlot> glaMap = new HashMap<PlotEx, SimpleLayoutDirector.AxesInPlot>();
        for (PlotEx subplot : subplots) {
            SimpleLayoutDirector.AxesInPlot ais = GridLayoutDirector.getAllAxes(subplot);
            glaMap.put(subplot, ais);
        }
        return glaMap;
    }

    public GridLayoutDirector() {
        this(0.0, 0.0);
    }

    public GridLayoutDirector(double hgap, double vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public double getHGap() {
        return this.hgap;
    }

    public double getVGap() {
        return this.vgap;
    }

    @Override
    public void invalidateLayout(PlotEx plot) {
        this.plotsPreferredContentsGeomMap.remove(plot);
        this.plotsMarginGeomMap.remove(plot);
    }

    @Override
    public void layout(PlotEx plot) {
        super.layout(plot);
        GridCellGeom contGeom = this.getSubplotsPreferredContentsGeom(plot);
        GridCellInsets marginGeom = this.getSubplotsMarginGeom(plot);
        Dimension2D scsFactor = this.calcSubplotContentFactor(plot, marginGeom);
        SparseDoubleArray cellWidthMap = new SparseDoubleArray();
        SparseDoubleArray cellHeightMap = new SparseDoubleArray();
        for (PlotEx sp : plot.getSubplots()) {
            GridConstraint grid = (GridConstraint)this.getConstraint(sp);
            int col = grid == null ? 0 : grid.getGridX();
            int row = grid == null ? 0 : grid.getGridY();
            double contWidth = scsFactor.getWidth() * contGeom.getWidth(col);
            double contHeight = scsFactor.getHeight() * contGeom.getHeight(row);
            sp.setContentConstrant(new DoubleDimension2D(contWidth, contHeight));
            double cw = marginGeom.getLeft(col) + contWidth + marginGeom.getRight(col);
            double ch = marginGeom.getTop(row) + contHeight + marginGeom.getBottom(row);
            if (cellWidthMap.get(col, -1) < cw) {
                cellWidthMap.put(col, cw);
            }
            if (!(cellHeightMap.get(row, -1) < ch)) continue;
            cellHeightMap.put(row, ch);
        }
        GridCellGeom cellGeom = new GridCellGeom(cellWidthMap, cellHeightMap);
        for (PlotEx sp : plot.getSubplots()) {
            GridConstraint grid = (GridConstraint)this.getConstraint(sp);
            int col = grid == null ? 0 : grid.getGridX();
            int row = grid == null ? 0 : grid.getGridY();
            double cws = cellGeom.getSumWidthLeft(col);
            double chs = cellGeom.getSumHeightBelow(row);
            double pX = cws + marginGeom.getLeft(col) + (double)cellWidthMap.indexOfKey(col) * this.hgap;
            double pY = chs + marginGeom.getBottom(row) + (double)cellHeightMap.indexOfKey(row) * this.vgap;
            sp.setLocation(pX, pY);
        }
    }

    private Dimension2D calcSubplotContentFactor(PlotEx subplot, GridCellInsets padding) {
        double yfactor;
        double xfactor;
        double ctsWidth = subplot.getContentSize().getWidth();
        double ctsHeight = subplot.getContentSize().getHeight();
        GridCellGeom contGeom = this.getSubplotsPreferredContentsGeom(subplot);
        double sumWeightX = contGeom.getSumWidth();
        double sumWeightY = contGeom.getSumHeight();
        double xn = contGeom.getColNum();
        double yn = contGeom.getRowNum();
        double sumXpad = padding.getSumWidth();
        double sumYpad = padding.getSumHeight();
        if (xn == 0.0 || yn == 0.0) {
            xfactor = ctsWidth;
            yfactor = ctsHeight;
        } else {
            xfactor = (ctsWidth - sumXpad - this.hgap * (xn - 1.0)) / sumWeightX;
            yfactor = (ctsHeight - sumYpad - this.vgap * (yn - 1.0)) / sumWeightY;
        }
        return new DoubleDimension2D(xfactor, yfactor);
    }

    @Override
    public Dimension2D getPreferredContentSize(PlotEx plot) {
        GridCellGeom contentGeom = this.getSubplotsPreferredContentsGeom(plot);
        GridCellInsets marginGeom = this.getSubplotsMarginGeom(plot);
        SparseDoubleArray colWidthMap = new SparseDoubleArray();
        SparseDoubleArray rowHeightMap = new SparseDoubleArray();
        for (PlotEx sp : plot.getSubplots()) {
            GridConstraint grid = (GridConstraint)this.getConstraint(sp);
            int col = grid == null ? 0 : grid.getGridX();
            int row = grid == null ? 0 : grid.getGridY();
            double width = contentGeom.getWidth(col) + marginGeom.getLeft(col) + marginGeom.getRight(col);
            double Height = contentGeom.getHeight(row) + marginGeom.getTop(row) + marginGeom.getBottom(row);
            if (colWidthMap.get(col, -1) < width) {
                colWidthMap.put(col, width);
            }
            if (!(rowHeightMap.get(row, -1) < Height)) continue;
            rowHeightMap.put(row, Height);
        }
        GridCellGeom geom = new GridCellGeom(colWidthMap, rowHeightMap);
        double width = geom.getSumWidth() + this.hgap * (double)(colWidthMap.size() - 1);
        double height = geom.getSumHeight() + this.vgap * (double)(rowHeightMap.size() - 1);
        Dimension2D spcs = plot.getPreferredContentSize();
        if (spcs != null && width < spcs.getWidth()) {
            width = spcs.getWidth();
        }
        if (spcs != null && height < spcs.getHeight()) {
            height = spcs.getHeight();
        }
        return new DoubleDimension2D(width, height);
    }

    private GridCellGeom getSubplotsPreferredContentsGeom(PlotEx plot) {
        if (this.plotsPreferredContentsGeomMap.containsKey(plot)) {
            return this.plotsPreferredContentsGeomMap.get(plot);
        }
        SparseDoubleArray colWidthMap = new SparseDoubleArray();
        SparseDoubleArray rowHeightMap = new SparseDoubleArray();
        for (PlotEx sp : plot.getSubplots()) {
            GridConstraint grid = (GridConstraint)this.getConstraint(sp);
            int col = grid == null ? 0 : grid.getGridX();
            int row = grid == null ? 0 : grid.getGridY();
            double width = 0.0;
            double Height = 0.0;
            Dimension2D contentSize = sp.getLayoutDirector().getPreferredContentSize(sp);
            if (contentSize != null) {
                width = contentSize.getWidth();
                Height = contentSize.getHeight();
            }
            if (colWidthMap.get(col, -1) < width) {
                colWidthMap.put(col, width);
            }
            if (!(rowHeightMap.get(row, -1) < Height)) continue;
            rowHeightMap.put(row, Height);
        }
        GridCellGeom geom = new GridCellGeom(colWidthMap, rowHeightMap);
        this.plotsPreferredContentsGeomMap.put(plot, geom);
        return geom;
    }

    private GridCellInsets getSubplotsMarginGeom(PlotEx plot) {
        if (this.plotsMarginGeomMap.containsKey(plot)) {
            return this.plotsMarginGeomMap.get(plot);
        }
        Map<PlotEx, SimpleLayoutDirector.AxesInPlot> saMap = GridLayoutDirector.getSubplotAxisMap(plot.getSubplots());
        SparseDoubleArray topMargin = new SparseDoubleArray();
        SparseDoubleArray leftMargin = new SparseDoubleArray();
        SparseDoubleArray bottomMargin = new SparseDoubleArray();
        SparseDoubleArray rightMargin = new SparseDoubleArray();
        for (Map.Entry<PlotEx, SimpleLayoutDirector.AxesInPlot> me : saMap.entrySet()) {
            PlotEx sp = me.getKey();
            SimpleLayoutDirector.AxesInPlot ais = me.getValue();
            GridConstraint grid = (GridConstraint)this.getConstraint(sp);
            int col = grid == null ? 0 : grid.getGridX();
            int row = grid == null ? 0 : grid.getGridY();
            double mLeft = GridLayoutDirector.calcLeftMargin(sp, ais.leftAxes);
            double mRight = GridLayoutDirector.calcRightMargin(sp, ais.rightAxes);
            double mTop = GridLayoutDirector.calcTopMargin(sp, ais.topAxes);
            double mBottom = GridLayoutDirector.calcBottomMargin(sp, ais.bottomAxes);
            if (leftMargin.get(col, -1) < mLeft) {
                leftMargin.put(col, mLeft);
            }
            if (rightMargin.get(col, -1) < mRight) {
                rightMargin.put(col, mRight);
            }
            if (topMargin.get(row, -1) < mTop) {
                topMargin.put(row, mTop);
            }
            if (!(bottomMargin.get(row, -1) < mBottom)) continue;
            bottomMargin.put(row, mBottom);
        }
        GridCellInsets insets = new GridCellInsets(topMargin, leftMargin, bottomMargin, rightMargin);
        this.plotsMarginGeomMap.put(plot, insets);
        return insets;
    }
}

