/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.Plot;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseWheelBehaviorHandler;
import org.jplot2d.interaction.MouseWheelFinerZoomBehavior;
import org.jplot2d.notice.UINoticeType;

public class MouseWheelFinerZoomHandler
extends MouseWheelBehaviorHandler<MouseWheelFinerZoomBehavior> {
    public MouseWheelFinerZoomHandler(MouseWheelFinerZoomBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean behaviorPerformed(int x, int y, int wheelRotation) {
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        Plot plot = env.getPlotAt(new Point(x, y));
        if (plot == null) {
            return false;
        }
        double factor = Math.sqrt(Math.sqrt(2.0));
        double scale = 1.0;
        if (wheelRotation > 0) {
            scale = factor;
        } else if (wheelRotation < 0) {
            scale = 1.0 / factor;
        }
        BatchToken token = env.beginBatch("WheelZoom");
        Dimension2D csize = plot.getContentSize();
        Rectangle2D.Double cbnds = new Rectangle2D.Double(0.0, 0.0, csize.getWidth(), csize.getHeight());
        Rectangle2D plotRect = plot.getPaperTransform().getPtoD(cbnds).getBounds2D();
        double npx = ((double)x - plotRect.getX()) / plotRect.getWidth();
        double startx = npx * (1.0 - scale);
        double endx = startx + scale;
        double npy = 1.0 - ((double)y - plotRect.getY()) / plotRect.getHeight();
        double starty = npy * (1.0 - scale);
        double endy = starty + scale;
        plot.zoomXRange(startx, endx);
        plot.zoomYRange(starty, endy);
        env.endBatch(token, UINoticeType.getInstance());
        return true;
    }
}

