/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import org.jplot2d.interaction.MouseButtonCombination;

public class MouseButtonCombinationEnablity {
    private static int CLICK_COUNT_MASK = 458752;
    private static int BUTTON_MASK = 15;
    private boolean enabled;
    private MouseButtonCombination mbc;

    public MouseButtonCombinationEnablity(int modifiersOnMask, int clickCount, int button) {
        this(modifiersOnMask, clickCount, button, true);
    }

    public MouseButtonCombinationEnablity(int modifiersOnMask, int clickCount, int button, boolean enabled) {
        this.enabled = enabled;
        this.mbc = new MouseButtonCombination(modifiersOnMask, clickCount, button);
    }

    public MouseButtonCombinationEnablity(MouseButtonCombination mbc, boolean enabled) {
        this.enabled = enabled;
        this.mbc = mbc;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public MouseButtonCombination getMouseButtonCombination() {
        return this.mbc;
    }

    public void setMouseButtonCombination(MouseButtonCombination mbc) {
        this.mbc = mbc;
    }

    private int intValue() {
        if (this.mbc == null) {
            return -1;
        }
        return this.mbc.getButton() + this.mbc.getModifiers() + (this.mbc.getClickCount() << 16) + (this.enabled ? 0 : Integer.MIN_VALUE);
    }

    public String toString() {
        return this.mbc == null ? "" : String.valueOf(this.intValue());
    }

    public static MouseButtonCombinationEnablity valueOf(String s) {
        int v = Integer.parseInt(s);
        int button = v & BUTTON_MASK;
        int modifiers = v & 0x3FC0;
        int clickCount = (v & CLICK_COUNT_MASK) >> 16;
        boolean enabled = (v & Integer.MIN_VALUE) == 0;
        return new MouseButtonCombinationEnablity(modifiers, clickCount, button, enabled);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonCombinationEnablity) {
            MouseButtonCombinationEnablity mbce = (MouseButtonCombinationEnablity)obj;
            return this.enabled == mbce.enabled && (this.mbc == mbce.mbc || this.mbc != null && this.mbc.equals(mbce.mbc));
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }
}

