/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.jplot2d.element.Axis;
import org.jplot2d.element.PComponent;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseAxisRangeZoomBehavior;
import org.jplot2d.interaction.MouseMarqueeHandler;
import org.jplot2d.notice.UINoticeType;

public class MouseAxisRangeZoomHandler
extends MouseMarqueeHandler<MouseAxisRangeZoomBehavior> {
    private Axis axis;

    public MouseAxisRangeZoomHandler(MouseAxisRangeZoomBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean canStartDargging(int x, int y) {
        PComponent pcomp = (PComponent)this.handler.getValue("ACTIVE_COMPONENT");
        if (pcomp instanceof Axis) {
            this.axis = (Axis)pcomp;
            return true;
        }
        return false;
    }

    @Override
    protected void handleMarquee(Point startPoint, Point endPoint) {
        double end;
        Point2D spp = this.axis.getPaperTransform().getDtoP(startPoint);
        Point2D epp = this.axis.getPaperTransform().getDtoP(endPoint);
        double start = spp.getX();
        if (start > (end = epp.getX())) {
            double temp = end;
            end = start;
            start = temp;
        }
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        BatchToken token = env.beginBatch("Axis Range Zoom");
        double length = this.axis.getLength();
        this.axis.getTickManager().getAxisTransform().getLockGroup().zoomRange(start / length, end / length);
        env.endBatch(token, UINoticeType.getInstance());
    }
}

