/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import org.jplot2d.element.Axis;
import org.jplot2d.element.AxisOrientation;
import org.jplot2d.element.PComponent;
import org.jplot2d.env.BatchToken;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseAxisPanBehavior;
import org.jplot2d.interaction.MouseDragBehaviorHandler;
import org.jplot2d.notice.UINoticeType;

public class MouseAxisPanHandler
extends MouseDragBehaviorHandler<MouseAxisPanBehavior> {
    private Axis axis;
    private int oldv;

    public MouseAxisPanHandler(MouseAxisPanBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
    }

    @Override
    public boolean canStartDargging(int x, int y) {
        PComponent pcomp = (PComponent)this.handler.getValue("ACTIVE_COMPONENT");
        if (pcomp instanceof Axis) {
            this.axis = (Axis)pcomp;
            return true;
        }
        return false;
    }

    @Override
    public void draggingStarted(int x, int y) {
        if (this.axis.getOrientation() == AxisOrientation.HORIZONTAL) {
            this.oldv = x;
        } else if (this.axis.getOrientation() == AxisOrientation.VERTICAL) {
            this.oldv = y;
        } else {
            throw new Error();
        }
    }

    @Override
    public void draggingTo(int x, int y) {
        int offset;
        if (this.axis.getOrientation() == AxisOrientation.HORIZONTAL) {
            offset = x - this.oldv;
            this.oldv = x;
        } else if (this.axis.getOrientation() == AxisOrientation.VERTICAL) {
            offset = this.oldv - y;
            this.oldv = y;
        } else {
            throw new Error();
        }
        PlotEnvironment env = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        BatchToken token = env.beginBatch("MarqueeZoom");
        double scale = this.axis.getPaperTransform().getScale();
        double npxStart = (double)(-offset) / (this.axis.getLength() * scale);
        double npxEnd = 1.0 + npxStart;
        this.axis.getTickManager().getAxisTransform().getLockGroup().zoomRange(npxStart, npxEnd);
        env.endBatch(token, UINoticeType.getInstance());
    }

    @Override
    public void draggingFinished(int x, int y) {
    }

    @Override
    public void draggingCancelled() {
    }
}

