/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.PComponent;
import org.jplot2d.env.PlotEnvironment;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.InteractiveComp;
import org.jplot2d.interaction.MouseActivateComponentBehavior;
import org.jplot2d.interaction.MouseMoveBehaviorHandler;
import org.jplot2d.interaction.VisualFeedbackDrawer;
import org.jplot2d.transform.PaperTransform;

public class MouseActivateComponentHandler
extends MouseMoveBehaviorHandler<MouseActivateComponentBehavior>
implements VisualFeedbackDrawer {
    private final InteractiveComp icomp;
    private PComponent activeComponent;

    public MouseActivateComponentHandler(MouseActivateComponentBehavior behavior, InteractionModeHandler handler) {
        super(behavior, handler);
        this.icomp = (InteractiveComp)handler.getValue("INTERACTIVE_COMP");
    }

    @Override
    public boolean behaviorPerformed(int x, int y) {
        Shape activeBounds;
        PlotEnvironment penv = (PlotEnvironment)this.handler.getValue("PLOT_ENV");
        if (this.activeComponent != null && this.activeComponent.getEnvironment() == penv && (activeBounds = MouseActivateComponentHandler.getDeviceBounds(this.activeComponent)) != null && activeBounds.contains(x, y)) {
            return false;
        }
        PComponent newComp = penv.getSelectableCompnentAt(new Point(x, y));
        if (this.activeComponent == newComp) {
            return false;
        }
        if (newComp != null) {
            this.activeComponent = newComp;
            this.handler.putValue("ACTIVE_COMPONENT", this.activeComponent);
        } else {
            this.activeComponent = null;
            this.handler.putValue("ACTIVE_COMPONENT", null);
        }
        this.icomp.repaint();
        return true;
    }

    @Override
    public void draw(Object g) {
        Shape activeBounds;
        if (this.activeComponent != null && (activeBounds = MouseActivateComponentHandler.getDeviceBounds(this.activeComponent)) != null) {
            this.icomp.drawShape(g, Color.BLUE.getRGB(), activeBounds);
        }
    }

    private static Shape getDeviceBounds(PComponent comp) {
        PaperTransform pxf = comp.getPaperTransform();
        Rectangle2D sb = comp.getSelectableBounds();
        if (pxf == null || sb == null) {
            return null;
        }
        return comp.getPaperTransform().getPtoD(comp.getSelectableBounds());
    }
}

