/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseButtonCombination;
import org.jplot2d.interaction.MouseButtonCombinationEnablity;
import org.jplot2d.interaction.MouseClickBehavior;
import org.jplot2d.interaction.MouseDragBehavior;
import org.jplot2d.interaction.MouseMoveBehavior;
import org.jplot2d.interaction.MousePreference;
import org.jplot2d.interaction.MouseWheelBehavior;

public abstract class InteractionManager {
    private int clickThreshold;
    private Map<String, InteractionMode> modeMap = new LinkedHashMap<String, InteractionMode>();
    private InteractionMode defaultMode;

    public int getClickThreshold() {
        return this.clickThreshold;
    }

    protected void registerMode(InteractionMode mode) {
        this.modeMap.put(mode.getName(), mode);
    }

    public InteractionMode getMode(String name) {
        return this.modeMap.get(name);
    }

    public InteractionMode[] getModes() {
        return this.modeMap.values().toArray(new InteractionMode[0]);
    }

    public InteractionMode getDefaultMode() {
        return this.defaultMode;
    }

    protected void setDefaultMode(InteractionMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    public void setMousePreference(MousePreference prefs) {
        this.clickThreshold = prefs.getClickThreshold();
        for (InteractionMode mode : this.modeMap.values()) {
            MouseBehavior[] behaviors;
            for (MouseBehavior behavior : behaviors = mode.getAvailableMouseBehaviors()) {
                MouseButtonCombination mba;
                MouseButtonCombinationEnablity mbce = prefs.getMouseButtonCombinationEnablity(mode, behavior);
                MouseButtonCombination mouseButtonCombination = mba = mbce == null || !mbce.isEnabled() ? null : mbce.getMouseButtonCombination();
                if (behavior instanceof MouseClickBehavior) {
                    mode.bindClickBehavior((MouseClickBehavior)behavior, mba);
                    continue;
                }
                if (behavior instanceof MouseMoveBehavior) {
                    mode.bindMoveBehavior((MouseMoveBehavior)behavior, mba);
                    continue;
                }
                if (behavior instanceof MouseDragBehavior) {
                    mode.bindDragBehavior((MouseDragBehavior)behavior, mba);
                    continue;
                }
                if (!(behavior instanceof MouseWheelBehavior)) continue;
                mode.bindWheelBehavior((MouseWheelBehavior)behavior, mba);
            }
        }
    }
}

