/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jplot2d.interaction.GenericMouseEvent;
import org.jplot2d.interaction.InteractionManager;
import org.jplot2d.interaction.InteractionMode;
import org.jplot2d.interaction.InteractionModeHandler;
import org.jplot2d.interaction.MouseBehavior;
import org.jplot2d.interaction.MouseBehaviorHandler;
import org.jplot2d.interaction.ValueChangeBehavior;
import org.jplot2d.interaction.ValueChangeHandler;
import org.jplot2d.interaction.VisualFeedbackDrawer;

public class InteractionHandler
implements VisualFeedbackDrawer {
    private final InteractionManager imanager;
    private InteractionModeHandler modeHandler;
    private final Map<InteractionMode, InteractionModeHandler> modeHandlerMap = new LinkedHashMap<InteractionMode, InteractionModeHandler>();
    private final Map<String, Object> valueMap = new HashMap<String, Object>();
    private int mouseSigDragState = 0;
    private int mouseTrivialDragState = 0;
    private Point lastPoint;

    public InteractionHandler(InteractionManager imanager) {
        this.imanager = imanager;
    }

    protected final InteractionManager getInteractionManager() {
        return this.imanager;
    }

    public void init() {
        for (InteractionMode mode : this.imanager.getModes()) {
            InteractionModeHandler mhandler = new InteractionModeHandler(this, mode);
            mhandler.valueMap.putAll(this.valueMap);
            this.modeHandlerMap.put(mode, mhandler);
            for (MouseBehavior behavior : mode.getAvailableMouseBehaviors()) {
                MouseBehaviorHandler<?> mbHandler = behavior.createMouseBehaviorHandler(mhandler);
                mhandler.addMouseBehaviorHandler(mbHandler);
            }
            for (ValueChangeBehavior feedback : mode.getValueChangeBehaviors()) {
                ValueChangeHandler<?> fbHandler = feedback.createValueChangeHandler(mhandler);
                mhandler.addValueChangeHandler(fbHandler);
            }
        }
        this.setMode(this.imanager.getDefaultMode());
    }

    public void keyPressed(int modifiers, int modifierKey) {
        this.modeHandler.keyPressed(modifiers, modifierKey);
    }

    public void keyReleased(int modifiers, int modifierKey) {
        this.modeHandler.keyReleased(modifiers, modifierKey);
    }

    public void mouseEntered(GenericMouseEvent e) {
        this.modeHandler.mouseEntered(e);
    }

    public void mouseExited(GenericMouseEvent e) {
        this.modeHandler.mouseExited(e);
    }

    public void mousePressed(GenericMouseEvent e) {
        this.modeHandler.mousePressed(e);
        this.lastPoint = new Point(e.getX(), e.getY());
        this.mouseTrivialDragState |= e.getButton();
    }

    public void mouseReleased(GenericMouseEvent e) {
        this.modeHandler.mouseReleased(e);
        if ((this.mouseTrivialDragState & ~this.mouseSigDragState & e.getButton()) != 0) {
            e = new GenericMouseEvent(500, e.getModifiers(), e.getX(), e.getY(), 1, e.getButton());
            this.mouseClicked(e);
        }
        this.mouseSigDragState &= ~e.getButton();
        this.mouseTrivialDragState &= ~e.getButton();
    }

    private void mouseClicked(GenericMouseEvent e) {
        this.modeHandler.mouseClicked(e);
    }

    public void mouseDragged(GenericMouseEvent e) {
        int mouseKeyState = e.getModifiers() & 0x1C00;
        int threshold = this.imanager.getClickThreshold();
        if (this.lastPoint == null || Math.abs(this.lastPoint.x - e.getX()) > threshold || Math.abs(this.lastPoint.y - e.getY()) > threshold) {
            this.lastPoint = null;
            this.mouseSigDragState = mouseKeyState;
            this.modeHandler.mouseDragged(e);
        } else {
            this.mouseTrivialDragState = mouseKeyState;
        }
    }

    public void mouseMoved(GenericMouseEvent e) {
        this.modeHandler.mouseMoved(e);
    }

    public void mouseWheelMoved(GenericMouseEvent e) {
        this.modeHandler.mouseWheelMoved(e);
    }

    @Override
    public void draw(Object graphics) {
        this.modeHandler.draw(graphics);
    }

    public InteractionMode getMode() {
        return this.modeHandler.getInteractionMode();
    }

    public void setMode(InteractionMode mode) {
        InteractionModeHandler newhandler = this.modeHandlerMap.get(mode);
        if (newhandler == null) {
            throw new IllegalArgumentException();
        }
        if (this.modeHandler != null) {
            this.modeHandler.modeExited();
        }
        this.modeHandler = newhandler;
        this.modeHandler.modeEntered();
    }

    public InteractionModeHandler getInteractionModeHandler(String modeName) {
        InteractionMode mode = this.imanager.getMode(modeName);
        if (mode == null) {
            return null;
        }
        return this.modeHandlerMap.get(mode);
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }

    public void putValue(String key, Object newValue) {
        if (this.valueMap.containsKey(key) && newValue == null) {
            this.valueMap.remove(key);
        } else {
            this.valueMap.put(key, newValue);
        }
    }
}

