/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.interaction;

import java.awt.event.InputEvent;

public class GenericMouseEvent {
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    private final int type;
    private final int modifiers;
    private final int x;
    private final int y;
    private final int count;
    private final int button;

    public GenericMouseEvent(int type, int modifiers, int x, int y, int count, int button) {
        this.type = type;
        this.modifiers = modifiers;
        this.x = x;
        this.y = y;
        this.count = count;
        this.button = button;
    }

    public int getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getCount() {
        return this.count;
    }

    public int getButton() {
        return this.button;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(80);
        switch (this.type) {
            case 501: {
                str.append("MOUSE_PRESSED");
                break;
            }
            case 502: {
                str.append("MOUSE_RELEASED");
                break;
            }
            case 500: {
                str.append("MOUSE_CLICKED");
                break;
            }
            case 504: {
                str.append("MOUSE_ENTERED");
                break;
            }
            case 505: {
                str.append("MOUSE_EXITED");
                break;
            }
            case 503: {
                str.append("MOUSE_MOVED");
                break;
            }
            case 506: {
                str.append("MOUSE_DRAGGED");
                break;
            }
            case 507: {
                str.append("MOUSE_WHEEL");
                break;
            }
            default: {
                str.append("unknown type");
            }
        }
        str.append(",(").append(this.x).append(",").append(this.y).append(")");
        str.append(",button=").append(this.getButton());
        if (this.modifiers != 0) {
            str.append(",modifiers=").append(InputEvent.getModifiersExText(this.modifiers));
        }
        str.append(",count=").append(this.count);
        return str.toString();
    }
}

