/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.awt.Color;
import java.awt.Paint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.jplot2d.element.Element;
import org.jplot2d.env.InterfaceInfo;
import org.jplot2d.env.PropertyInfo;
import org.jplot2d.env.StyleConfiguration;

public class StylePreferences
implements StyleConfiguration {
    private static Object IGNORE = new Object();
    private Preferences pref;

    public StylePreferences() {
        this.pref = Preferences.userRoot().node("org/jplot2d/profile/default");
    }

    public StylePreferences(String pathName) {
        this.pref = Preferences.userRoot().node(pathName);
    }

    @Override
    public void applyTo(Element element) {
        Class<?> eif = StylePreferences.getElementInterface(element.getClass());
        if (eif == null) {
            return;
        }
        Preferences node = this.pref.node(eif.getSimpleName());
        InterfaceInfo iinfo = InterfaceInfo.loadInterfaceInfo(eif);
        for (PropertyInfo[] pinfos : iinfo.getProfilePropertyInfoGroupMap().values()) {
            for (PropertyInfo pinfo : pinfos) {
                String pname = pinfo.getName();
                Method reader = pinfo.getReadMethod();
                if (pinfo.getWriteMethod() == null) continue;
                try {
                    Object oldValue = reader.invoke((Object)element, new Object[0]);
                    String pvalue = node.get(pname, null);
                    if (pvalue == null) {
                        node.put(pname, this.toString(oldValue));
                        continue;
                    }
                    if (this.toString(oldValue).equals(pvalue)) continue;
                    Method writter = pinfo.getWriteMethod();
                    Class<?> ptype = pinfo.getPropertyType();
                    Object v = this.parse(pvalue, ptype);
                    if (v == IGNORE) continue;
                    writter.invoke((Object)element, v);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
        }
    }

    private String toString(Object obj) {
        if (obj instanceof Color) {
            return "0x" + Integer.toHexString(((Color)obj).getRGB());
        }
        return String.valueOf(obj);
    }

    private Object parse(String s, Class ptype) {
        if (s.equals("null")) {
            return null;
        }
        if (ptype == String.class) {
            return s;
        }
        try {
            if (ptype == Boolean.TYPE) {
                return Boolean.parseBoolean(s);
            }
            if (ptype == Byte.TYPE) {
                return Byte.parseByte(s);
            }
            if (ptype == Short.TYPE) {
                return Short.parseShort(s);
            }
            if (ptype == Integer.TYPE) {
                return Integer.parseInt(s);
            }
            if (ptype == Long.TYPE) {
                return Long.parseLong(s);
            }
            if (ptype == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (ptype == Double.TYPE) {
                return Double.parseDouble(s);
            }
            if (ptype.isEnum()) {
                return Enum.valueOf(ptype, s);
            }
            if (ptype == Paint.class) {
                return Color.decode(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IGNORE;
    }

    protected static Class<?> getElementInterface(Class<?> element) {
        if (element.getPackage().getName().equals("org.jplot2d.element")) {
            return element;
        }
        Class<?>[] interfaces = element.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> eif = StylePreferences.getElementInterface(interfaces[i]);
            if (eif == null) continue;
            return eif;
        }
        return null;
    }

    @Override
    public <T extends Element> T getProxyBean(Class<T> elementInterface) {
        return null;
    }
}

