/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class PropertyInfo
implements Comparable<PropertyInfo> {
    private final String name;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> type;
    private String displayName;
    private int displayDigits;
    private String shortDescription;
    private boolean readOnly;
    private int order;
    private boolean styleable;

    public PropertyInfo(String pname, Method reader, Method writer) throws IntrospectionException {
        this.name = pname;
        this.readMethod = reader;
        this.writeMethod = writer;
        this.type = this.findPropertyType(this.readMethod, this.writeMethod);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getPropertyType() {
        return this.type;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return this.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getDisplayDigits() {
        return this.displayDigits;
    }

    public void setDisplayDigits(int digits) {
        this.displayDigits = digits;
    }

    public String getShortDescription() {
        if (this.shortDescription == null || this.shortDescription.length() == 0) {
            return this.getDisplayName();
        }
        return this.shortDescription;
    }

    public void setShortDescription(String text) {
        this.shortDescription = text;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isStyleable() {
        return this.styleable;
    }

    public void setStyleable(boolean styleable) {
        this.styleable = styleable;
    }

    private Class<?> findPropertyType(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> propertyType = null;
        if (readMethod != null) {
            params = readMethod.getParameterTypes();
            if (params.length != 0) {
                throw new IntrospectionException("bad read method arg count: " + readMethod);
            }
            propertyType = readMethod.getReturnType();
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + readMethod.getName() + " returns void");
            }
        }
        if (writeMethod != null) {
            params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("bad write method arg count: " + writeMethod);
            }
            if (propertyType != null && propertyType != params[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            propertyType = params[0];
        }
        if (propertyType == null) {
            throw new IntrospectionException("Both read and write methods are null");
        }
        return propertyType;
    }

    @Override
    public int compareTo(PropertyInfo o) {
        return this.order - o.order;
    }

    public String toString() {
        return this.name;
    }
}

