/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.env;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.jplot2d.element.Element;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.Joinable;
import org.jplot2d.env.DummyEnvironment;
import org.jplot2d.env.ElementAddition;
import org.jplot2d.env.Environment;
import org.jplot2d.env.InterfaceInfo;

public class ElementIH
implements InvocationHandler {
    private final InterfaceInfo iinfo;
    private ElementEx impl;
    protected volatile Environment environment;

    public ElementIH(ElementEx impl, Class<?> clazz) {
        this.impl = impl;
        this.iinfo = InterfaceInfo.loadInterfaceInfo(clazz);
    }

    void replaceImpl(ElementEx impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals")) {
            if (proxy == args[0]) {
                return Boolean.TRUE;
            }
            if (args[0] == null) {
                return Boolean.FALSE;
            }
        }
        if (this.iinfo.isListenerMethod(method)) {
            try {
                return method.invoke((Object)this.impl, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        if (method.getName().equals("getEnvironment")) {
            Object ex = Environment.getGlobalLock();
            synchronized (ex) {
                return this.environment;
            }
        }
        if (method.getName().equals("setEnvironment")) {
            assert (Thread.holdsLock(Environment.getGlobalLock()));
            this.environment = (Environment)args[0];
            return null;
        }
        if (method.getName().equals("getImpl")) {
            return this.impl;
        }
        if (this.iinfo.isGetCompMethod(method)) {
            return this.invokeGetCompMethod(method, args);
        }
        if (this.iinfo.isGetCompArrayMethod(method)) {
            return this.invokeGetCompArrayMethod(method, args);
        }
        if (this.iinfo.isAddCompMethod(method)) {
            if (args[0] instanceof Object[]) {
                this.invokeAddCompArrayMethod(method, args);
            } else {
                this.invokeAddCompMethod(method, args);
            }
            return null;
        }
        if (this.iinfo.isRemoveCompMethod(method)) {
            this.invokeRemoveCompMethod(method, args);
            return null;
        }
        if (this.iinfo.isJoinElementMethod(method)) {
            this.invokeJoinElementMethod(method, args);
            return null;
        }
        if (this.iinfo.isRefElementMethod(method)) {
            this.invokeSetRefElementMethod(method, args);
            return null;
        }
        if (this.iinfo.isRef2ElementMethod(method)) {
            this.invokeSetRef2ElementMethod(method, args);
            return null;
        }
        if (this.iinfo.isAddRef2Method(method)) {
            this.invokeAddRefMethod(method, args, 2);
            return null;
        }
        this.environment.begin();
        try {
            if (method.getName().equals("equals")) {
                Boolean ex = proxy == args[0];
                return ex;
            }
            if (method.getName().equals("hashCode")) {
                Integer ex = this.impl.hashCode();
                return ex;
            }
            if (method.getName().equals("toString")) {
                String ex = "Proxy@" + System.identityHashCode(proxy) + "(" + this.impl.toString() + ")";
                return ex;
            }
            if (this.iinfo.isPropReadMethod(method)) {
                Object ex = this.invokeGetter(method);
                return ex;
            }
        }
        finally {
            this.environment.end();
        }
        this.environment.beginCommand(method.getName());
        try {
            if (this.iinfo.isPropWriteMethod(method)) {
                boolean propChanged = this.invokeSetter(method, args);
                if (propChanged) {
                    this.environment.elementPropertyChanged(this.impl);
                }
            } else {
                this.invokeOther(method, args);
                this.environment.elementPropertyChanged(this.impl);
            }
        }
        finally {
            this.environment.endCommand();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeGetCompMethod(Method method, Object[] args) throws Throwable {
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            this.environment.begin();
        }
        try {
            ElementEx compImpl = (ElementEx)method.invoke((Object)this.impl, args);
            Element element = this.environment.getProxy(compImpl);
            return element;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            this.environment.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeGetCompArrayMethod(Method method, Object[] args) throws Throwable {
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            this.environment.begin();
        }
        try {
            Object compImpls = method.invoke((Object)this.impl, args);
            int length = Array.getLength(compImpls);
            Object result = Array.newInstance(method.getReturnType().getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(result, i, this.environment.getProxy((ElementEx)Array.get(compImpls, i)));
            }
            Object object2 = result;
            return object2;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            this.environment.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAddCompArrayMethod(Method method, Object[] args) throws Throwable {
        Environment cenv;
        Environment penv;
        if (((Object[])args[0]).length == 0) {
            return;
        }
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            penv = this.environment;
            Object[] arg0 = (Object[])args[0];
            cenv = ((Element)arg0[0]).getEnvironment();
            for (int i = 1; i < arg0.length; ++i) {
                if (cenv == ((Element)arg0[i]).getEnvironment()) continue;
                throw new IllegalArgumentException("The components to be added must belong to the same envoriment.");
            }
            Class<?> arg0LcType = method.getParameterTypes()[0].getComponentType();
            Object cimpls = Array.newInstance(arg0LcType, arg0.length);
            cenv.beginCommand(method.getName());
            for (int i = 0; i < arg0.length; ++i) {
                ComponentEx cimpl = (ComponentEx)((ElementAddition)arg0[i]).getImpl();
                if (cimpl.getParent() != null) {
                    cenv.endCommand();
                    throw new IllegalArgumentException("At lease one of the components to be added already has a parent.");
                }
                Array.set(cimpls, i, cimpl);
            }
            penv.beginCommand(method.getName());
            this.logCommand(method, args);
            Object[] cargs = (Object[])args.clone();
            cargs[0] = cimpls;
            try {
                method.invoke((Object)this.impl, cargs);
            }
            catch (InvocationTargetException e) {
                penv.endCommand();
                cenv.endCommand();
                throw e.getCause();
            }
            for (Element proxy : cenv.proxyMap.values()) {
                ((ElementAddition)((Object)proxy)).setEnvironment(penv);
            }
            for (int i = 0; i < Array.getLength(cimpls); ++i) {
                penv.componentAdded((ComponentEx)Array.get(cimpls, i), cenv);
            }
        }
        penv.endCommand();
        cenv.endCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAddCompMethod(Method method, Object[] args) throws Throwable {
        Environment cenv;
        Environment penv;
        ElementAddition cproxy = (ElementAddition)args[0];
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            penv = this.environment;
            cenv = ((Element)args[0]).getEnvironment();
            cenv.beginCommand(method.getName());
            ComponentEx cimpl = (ComponentEx)cproxy.getImpl();
            if (cimpl.getParent() != null) {
                cenv.endCommand();
                throw new IllegalArgumentException("The component to be added already has a parent.");
            }
            penv.beginCommand(method.getName());
            this.logCommand(method, args);
            Object[] cargs = (Object[])args.clone();
            cargs[0] = cimpl;
            try {
                method.invoke((Object)this.impl, cargs);
            }
            catch (InvocationTargetException e) {
                penv.endCommand();
                cenv.endCommand();
                throw e.getCause();
            }
            for (Element proxy : cenv.proxyMap.values()) {
                ((ElementAddition)((Object)proxy)).setEnvironment(penv);
            }
            penv.componentAdded(cimpl, cenv);
        }
        penv.endCommand();
        cenv.endCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeRemoveCompMethod(Method method, Object[] args) throws Throwable {
        Environment penv;
        ElementAddition cproxy = (ElementAddition)args[0];
        Throwable throwable = null;
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            penv = this.environment;
            penv.beginCommand(method.getName());
            ComponentEx cimpl = (ComponentEx)cproxy.getImpl();
            if (cimpl.getParent() != this.impl) {
                throwable = new IllegalArgumentException("The component to be removed dosn't belong to this container.");
            } else {
                Map<Element, Element> mooringMap = cimpl.getMooringMap();
                if (mooringMap.size() > 0) {
                    String msg = "The removing is not allowed, because some element is required.\n";
                    for (Map.Entry<Element, Element> me : mooringMap.entrySet()) {
                        msg = msg + "\t" + me.getKey() + " is required by " + me.getValue() + "\n";
                    }
                    throwable = new IllegalStateException(msg);
                } else {
                    this.logCommand(method, args);
                    penv.componentRemoving(cimpl);
                    Object[] cargs = (Object[])args.clone();
                    cargs[0] = cimpl;
                    try {
                        method.invoke((Object)this.impl, cargs);
                    }
                    catch (InvocationTargetException e) {
                        throwable = e.getCause();
                    }
                }
            }
            if (throwable == null) {
                DummyEnvironment cenv = penv.componentRemoved(cimpl);
                for (Element proxy : cenv.proxyMap.values()) {
                    ((ElementAddition)((Object)proxy)).setEnvironment(cenv);
                }
            }
        }
        penv.endCommand();
        if (throwable != null) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeJoinElementMethod(Method method, Object[] args) throws Throwable {
        Environment cenv;
        Environment env;
        if (args[0] == null) {
            throw new IllegalArgumentException("Null is not a valid argument.");
        }
        boolean add = false;
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            Method reader;
            Object oldRef;
            env = this.environment;
            cenv = ((Element)args[0]).getEnvironment();
            cenv.beginCommand(method.getName());
            ElementEx cimpl = ((ElementAddition)args[0]).getImpl();
            if (env != cenv) {
                if (cimpl instanceof Joinable) {
                    if (((Joinable)((Object)cimpl)).getPrim() != null) {
                        cenv.endCommand();
                        throw new IllegalArgumentException("The element to be referenced has been referenced by element from another environment.");
                    }
                } else {
                    cenv.endCommand();
                    throw new IllegalArgumentException("The argument is not referencable.");
                }
                add = true;
                env.beginCommand(method.getName());
            }
            if (cimpl == (oldRef = this.invokeGetter(reader = this.iinfo.getPropReadMethodByWriteMethod(method)))) {
                if (add) {
                    cenv.endCommand();
                }
                env.endCommand();
                return;
            }
            this.logCommand(method, args);
            Object[] cargs = (Object[])args.clone();
            cargs[0] = cimpl;
            try {
                method.invoke((Object)this.impl, cargs);
            }
            catch (InvocationTargetException e) {
                env.endCommand();
                if (add) {
                    cenv.endCommand();
                }
                throw e.getCause();
            }
            for (Element proxy : cenv.proxyMap.values()) {
                ((ElementAddition)((Object)proxy)).setEnvironment(env);
            }
            if (add) {
                env.elementAdded(cimpl, cenv);
            }
            if (oldRef != null && ((Joinable)oldRef).getPrim() == null) {
                DummyEnvironment nenv = env.componentRemoved((ElementEx)oldRef);
                for (Element proxy : nenv.proxyMap.values()) {
                    ((ElementAddition)((Object)proxy)).setEnvironment(nenv);
                }
            }
        }
        env.endCommand();
        if (add) {
            cenv.endCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSetRefElementMethod(Method method, Object[] args) throws Throwable {
        ElementEx cimpl;
        Environment env;
        if (args[0] == null) {
            throw new IllegalArgumentException("Null is not a valid argument.");
        }
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            env = this.environment;
            Environment cenv = ((Element)args[0]).getEnvironment();
            if (env != cenv) {
                throw new IllegalArgumentException("Must belongd to the same environment");
            }
            env.beginCommand(method.getName());
            cimpl = ((ElementAddition)args[0]).getImpl();
        }
        this.logCommand(method, args);
        Object[] cargs = (Object[])args.clone();
        cargs[0] = cimpl;
        try {
            method.invoke((Object)this.impl, cargs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            env.endCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSetRef2ElementMethod(Method method, Object[] args) throws Throwable {
        ElementEx cimpl1;
        ElementEx cimpl0;
        Environment env;
        if (args[0] == null || args[1] == null) {
            throw new IllegalArgumentException("Null is not a valid argument.");
        }
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            env = this.environment;
            if (((Element)args[0]).getEnvironment() != env) {
                throw new IllegalArgumentException("Must belongd to the same environment");
            }
            if (((Element)args[1]).getEnvironment() != env) {
                throw new IllegalArgumentException("Must belongd to the same environment");
            }
            env.beginCommand(method.getName());
            cimpl0 = ((ElementAddition)args[0]).getImpl();
            cimpl1 = ((ElementAddition)args[1]).getImpl();
        }
        this.logCommand(method, args);
        Object[] cargs = (Object[])args.clone();
        cargs[0] = cimpl0;
        cargs[1] = cimpl1;
        try {
            method.invoke((Object)this.impl, cargs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            env.endCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAddRefMethod(Method method, Object[] args, int nref) throws Throwable {
        ComponentEx cimpl;
        Environment cenv;
        Environment penv;
        ElementAddition cproxy = (ElementAddition)args[0];
        Object[] cargs = (Object[])args.clone();
        Object object = Environment.getGlobalLock();
        synchronized (object) {
            penv = this.environment;
            cenv = ((Element)args[0]).getEnvironment();
            cenv.beginCommand(method.getName());
            cimpl = (ComponentEx)cproxy.getImpl();
            if (cimpl.getParent() != null) {
                cenv.endCommand();
                throw new IllegalArgumentException("The component to be added already has a parent.");
            }
            penv.beginCommand(method.getName());
            this.logCommand(method, args);
            for (Element proxy : cenv.proxyMap.values()) {
                ((ElementAddition)((Object)proxy)).setEnvironment(penv);
            }
            for (int i = 1; i <= nref; ++i) {
                if (((Element)args[i]).getEnvironment() != penv) {
                    throw new IllegalArgumentException("The argument " + args[i] + " must belong to the environment of the container.");
                }
                cargs[i] = args[i] == null ? null : ((ElementAddition)args[i]).getImpl();
            }
        }
        cargs[0] = cimpl;
        try {
            method.invoke((Object)this.impl, cargs);
            penv.componentAdded(cimpl, cenv);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            penv.endCommand();
            cenv.endCommand();
        }
    }

    protected Object invokeGetter(Method method) throws Throwable {
        try {
            return method.invoke((Object)this.impl, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected boolean invokeSetter(Method method, Object[] args) throws Throwable {
        if (this.iinfo.isPropWriteDisabled(method)) {
            throw new UnsupportedOperationException("The property setter " + method.getName() + " is unsupported.");
        }
        Object oldValue = null;
        Method reader = this.iinfo.getPropReadMethodByWriteMethod(method);
        oldValue = this.invokeGetter(reader);
        if (args[0] == oldValue) {
            return false;
        }
        if (args[0] != null && args[0].equals(oldValue)) {
            return false;
        }
        this.logCommand(method, args);
        try {
            method.invoke((Object)this.impl, args[0]);
            boolean bl = true;
            return bl;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected Object invokeOther(Method method, Object[] args) throws Throwable {
        this.logCommand(method, args);
        try {
            return method.invoke((Object)this.impl, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void logCommand(Method method, Object[] args) {
        StringBuilder sb = new StringBuilder();
        ElementIH.fillElementExpString(sb, this.environment, this.impl);
        sb.append(".");
        sb.append(method.getName());
        sb.append("(");
        if (args != null && args.length > 0) {
            ElementIH.fillArgString(sb, args[0]);
            for (int i = 1; i < args.length; ++i) {
                sb.append(", ");
                ElementIH.fillArgString(sb, args[i]);
            }
        }
        sb.append(")");
        if (this.environment.cmdLogger != null) {
            this.environment.cmdLogger.log(sb.toString());
        }
    }

    private static void fillArgString(StringBuilder sb, Object arg) {
        if (arg instanceof Element) {
            ElementIH.fillElementExpString(sb, ((Element)arg).getEnvironment(), ((ElementAddition)arg).getImpl());
        } else if (arg instanceof Element[]) {
            sb.append("[");
            if (((Element[])arg).length > 0) {
                ElementIH.fillArgString(sb, ((Element[])arg)[0]);
                for (int i = 1; i < ((Element[])arg).length; ++i) {
                    sb.append(", ");
                    ElementIH.fillArgString(sb, ((Element[])arg)[i]);
                }
            }
            sb.append("]");
        } else if (arg instanceof String) {
            sb.append("\"");
            sb.append(arg);
            sb.append("\"");
        } else {
            sb.append(arg);
        }
    }

    private static void fillElementExpString(StringBuilder sb, Environment env, Object obj) {
        if (obj instanceof ElementEx) {
            ElementEx parent = obj instanceof Joinable ? ((Joinable)obj).getPrim() : ((ElementEx)obj).getParent();
            InvokeStep ivs = null;
            if (parent != null) {
                ivs = ((ElementEx)obj).getInvokeStepFormParent();
            }
            if (ivs != null) {
                ElementIH.fillElementExpString(sb, env, parent);
                sb.append(".");
                sb.append(ivs.getMethod().getName());
                sb.append("(");
                if (ivs.getIndex() >= 0) {
                    sb.append(ivs.getIndex());
                }
                sb.append(")");
                return;
            }
            sb.append(String.valueOf(env.getProxy((ElementEx)obj)));
            return;
        }
        sb.append(obj.toString());
    }
}

