/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Map;
import org.jplot2d.data.XYGraphData;
import org.jplot2d.element.XYGraph;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.GraphImpl;
import org.jplot2d.element.impl.LegendItemEx;
import org.jplot2d.element.impl.XYGraphDataChunker;
import org.jplot2d.element.impl.XYGraphEx;
import org.jplot2d.element.impl.XYGraphFiller;
import org.jplot2d.element.impl.XYLegendItemEx;
import org.jplot2d.element.impl.XYLegendItemImpl;
import org.jplot2d.util.GraphicsUtil;
import org.jplot2d.util.SparseArray;
import org.jplot2d.util.SymbolShape;

public class XYGraphImpl
extends GraphImpl
implements XYGraphEx {
    private static Paint DEFAULT_FILL_PAINT = new Color(192, 192, 192, 128);
    private static final float ARROW_LENGTH = 12.0f;
    private static final float ARROW_HEAD_LENGTH = 3.0f;
    private final LegendItemEx legendItem;
    private XYGraphData data;
    private boolean symbolVisible = false;
    private boolean lineVisible = true;
    private XYGraph.ChartType chartType = XYGraph.ChartType.LINECHART;
    private SymbolShape symbolShape = SymbolShape.CIRCLE;
    private float symbolSize = 8.0f;
    private Color symbolColor;
    private final SparseArray<Color> symbolColors = new SparseArray();
    private BasicStroke lineStroke = new BasicStroke(0.5f, 0, 0);
    private boolean fillEnabled;
    private Paint fillPaint = DEFAULT_FILL_PAINT;
    private XYGraph.FillClosureType fillClosureType = XYGraph.FillClosureType.SELF;
    private float errorbarCapSize;

    public XYGraphImpl() {
        this.legendItem = new XYLegendItemImpl();
        this.legendItem.setParent(this);
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "XYGraph" + this.getParent().indexOf(this);
        }
        return "XYGraph@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public XYLegendItemEx getLegendItem() {
        return (XYLegendItemEx)this.legendItem;
    }

    @Override
    public String getName() {
        return ((XYLegendItemImpl)this.getLegendItem()).getText();
    }

    @Override
    public void setName(String text) {
        ((XYLegendItemImpl)this.getLegendItem()).setText(text);
    }

    @Override
    public XYGraphData getData() {
        return this.data;
    }

    @Override
    public void setData(XYGraphData data) {
        this.data = data;
        XYGraphImpl.redraw(this);
        if (this.getParent() != null && this.canContribute()) {
            AxisTransformEx xarm = this.getParent().getXAxisTransform();
            AxisTransformEx yarm = this.getParent().getYAxisTransform();
            if (xarm != null && xarm.getLockGroup().isAutoRange()) {
                xarm.getLockGroup().reAutoRange();
            }
            if (yarm != null && yarm.getLockGroup().isAutoRange()) {
                yarm.getLockGroup().reAutoRange();
            }
        }
    }

    @Override
    public boolean isSymbolVisible() {
        return this.symbolVisible;
    }

    @Override
    public void setSymbolVisible(boolean symbolVisible) {
        this.symbolVisible = symbolVisible;
        XYGraphImpl.redraw(this);
    }

    @Override
    public boolean isLineVisible() {
        return this.lineVisible;
    }

    @Override
    public void setLineVisible(boolean lineVisible) {
        this.lineVisible = lineVisible;
        XYGraphImpl.redraw(this);
    }

    @Override
    public XYGraph.ChartType getChartType() {
        return this.chartType;
    }

    @Override
    public void setChartType(XYGraph.ChartType chartType) {
        this.chartType = chartType;
        XYGraphImpl.redraw(this);
    }

    @Override
    public SymbolShape getSymbolShape() {
        return this.symbolShape;
    }

    @Override
    public void setSymbolShape(SymbolShape symbolShape) {
        this.symbolShape = symbolShape;
        XYGraphImpl.redraw(this);
    }

    @Override
    public float getSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public void setSymbolSize(float size) {
        this.symbolSize = size;
        XYGraphImpl.redraw(this);
        this.getLegendItem().graphSymbolSizeChanged();
    }

    @Override
    public Color getSymbolColor() {
        return this.symbolColor;
    }

    @Override
    public void setSymbolColor(Color color) {
        this.symbolColor = color;
        XYGraphImpl.redraw(this);
    }

    @Override
    public Color getIndSymbolColor(int idx) {
        if (this.symbolColors.size() > 0) {
            return this.symbolColors.get(idx);
        }
        return null;
    }

    @Override
    public void setIndSymbolColor(int idx, Color color) {
        Color oldColor = this.getIndSymbolColor(idx);
        if (color == oldColor) {
            return;
        }
        if (color == null || !color.equals(oldColor)) {
            this.symbolColors.put(idx, color);
            XYGraphImpl.redraw(this);
        }
    }

    @Override
    public void setIndSymbolColor(int[] idxes, Color color) {
        for (int idx : idxes) {
            this.symbolColors.put(idx, color);
        }
        XYGraphImpl.redraw(this);
    }

    @Override
    public void clearIndSymbolColor() {
        if (this.symbolColors.size() > 0) {
            this.symbolColors.clear();
            XYGraphImpl.redraw(this);
        }
    }

    @Override
    public Color getEffectiveSymbolColor() {
        if (this.getSymbolColor() != null) {
            return this.getSymbolColor();
        }
        return this.getEffectiveColor();
    }

    @Override
    public Color getEffectiveSymbolColor(int idx) {
        Color icolor = null;
        if (this.symbolColors.size() > 0) {
            icolor = this.symbolColors.get(idx);
        }
        if (icolor != null) {
            return icolor;
        }
        return this.getEffectiveSymbolColor();
    }

    @Override
    public void thisEffectiveColorChanged() {
        if (this.isLineVisible() || this.isSymbolVisible() && this.getSymbolColor() == null) {
            XYGraphImpl.redraw(this);
        }
    }

    @Override
    public BasicStroke getLineStroke() {
        return this.lineStroke;
    }

    @Override
    public void setLineStroke(BasicStroke stroke) {
        this.lineStroke = stroke;
        XYGraphImpl.redraw(this);
    }

    @Override
    public boolean isFillEnabled() {
        return this.fillEnabled;
    }

    @Override
    public void setFillEnabled(boolean fillEnabled) {
        this.fillEnabled = fillEnabled;
        XYGraphImpl.redraw(this);
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
        XYGraphImpl.redraw(this);
    }

    @Override
    public XYGraph.FillClosureType getFillClosureType() {
        return this.fillClosureType;
    }

    @Override
    public void setFillClosureType(XYGraph.FillClosureType type) {
        this.fillClosureType = type;
        XYGraphImpl.redraw(this);
    }

    @Override
    public float getErrorbarCapSize() {
        return this.errorbarCapSize;
    }

    @Override
    public void setErrorbarCapSize(float size) {
        this.errorbarCapSize = size;
        XYGraphImpl.redraw(this);
    }

    @Override
    public ComponentEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        XYGraphImpl result = (XYGraphImpl)super.copyStructure((Map)orig2copyMap);
        if (orig2copyMap != null) {
            orig2copyMap.put(this.getLegendItem(), result.getLegendItem());
        }
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        XYGraphImpl dp = (XYGraphImpl)src;
        this.data = dp.data;
        this.symbolVisible = dp.symbolVisible;
        this.lineVisible = dp.lineVisible;
        this.chartType = dp.chartType;
        this.symbolShape = dp.symbolShape;
        this.symbolSize = dp.symbolSize;
        this.symbolColor = dp.symbolColor;
        this.lineStroke = dp.lineStroke;
        this.fillEnabled = dp.fillEnabled;
        this.fillPaint = dp.fillPaint;
        this.fillClosureType = dp.fillClosureType;
        this.errorbarCapSize = dp.errorbarCapSize;
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (this.getParent().getXAxisTransform() == null || this.getParent().getYAxisTransform() == null) {
            return;
        }
        if (this.getData() == null) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics.create();
        Shape clip = this.getPaperTransform().getPtoD(this.getBounds());
        g.setClip(clip);
        if (this.isFillEnabled()) {
            if (Thread.interrupted()) {
                g.dispose();
                return;
            }
            this.fillLineAera(g);
        }
        if (Thread.interrupted()) {
            g.dispose();
            return;
        }
        this.drawLineAndSymbol(g);
        g.dispose();
    }

    private void fillLineAera(Graphics2D g) {
        XYGraphFiller filler = XYGraphFiller.getInstance(this, g.getClipBounds());
        Paint p = this.getFillPaint();
        filler.fill(g, p);
    }

    private void drawLineAndSymbol(Graphics2D g) {
        double scale = this.getParent().getPaperTransform().getScale();
        XYGraphDataChunker chunker = XYGraphDataChunker.getInstance(this, g.getClipBounds());
        for (XYGraphDataChunker.ChunkData data : chunker) {
            int i;
            if (Thread.interrupted()) {
                return;
            }
            g.setColor(this.getEffectiveColor());
            if (this.isLineVisible()) {
                switch (this.getChartType()) {
                    case LINECHART: {
                        XYGraphImpl.drawLine(g, data.xBuf, data.yBuf, data.size, this, scale);
                        break;
                    }
                    case HISTOGRAM: {
                        XYGraphImpl.drawHistogram(g, data, this, scale);
                        break;
                    }
                    case HISTOGRAM_EDGE: {
                        XYGraphImpl.drawEdgeHistogram(g, data.xBuf, data.yBuf, data.size, this, scale);
                    }
                }
            }
            g.setStroke(GraphicsUtil.scaleStroke(this.getLineStroke(), scale / 2.0));
            if (data.xErrorSize != 0) {
                for (i = 0; i < data.xErrorSize; ++i) {
                    this.drawErrorBarX(g, data.xBuf[i], data.yBuf[i], data.xLowBuf[i], data.xHighBuf[i], (float)scale);
                }
            }
            if (data.yErrorSize != 0) {
                for (i = 0; i < data.yErrorSize; ++i) {
                    this.drawErrorBarY(g, data.xBuf[i], data.yBuf[i], data.yLowBuf[i], data.yHighBuf[i], (float)scale);
                }
            }
            if (!this.isSymbolVisible()) continue;
            XYGraphImpl.drawMarks(g, data.xBuf, data.yBuf, data.size, this, data.markColorBuf, scale);
        }
    }

    private void drawErrorBarX(Graphics2D g, float x, float y, float low, float high, float scale) {
        if (!Float.isInfinite(low) && !Float.isInfinite(high)) {
            g.draw(new Line2D.Float(low, y, high, y));
        } else {
            float ah;
            float head;
            float tail;
            if (low == Float.NEGATIVE_INFINITY) {
                tail = high == Float.POSITIVE_INFINITY ? x : high;
                head = x < high ? x - 12.0f * scale : high - 12.0f * scale;
                g.draw(new Line2D.Float(tail, y, head, y));
                ah = 3.0f * scale;
                g.draw(new Line2D.Float(head, y, head + ah, y - ah));
                g.draw(new Line2D.Float(head, y, head + ah, y + ah));
            }
            if (high == Float.POSITIVE_INFINITY) {
                tail = low == Float.NEGATIVE_INFINITY ? x : low;
                head = x > low ? x + 12.0f * scale : low + 12.0f * scale;
                g.draw(new Line2D.Float(tail, y, head, y));
                ah = 3.0f * scale;
                g.draw(new Line2D.Float(head, y, head - ah, y - ah));
                g.draw(new Line2D.Float(head, y, head - ah, y + ah));
            }
        }
        if (this.errorbarCapSize > 0.0f) {
            float halfcap = this.errorbarCapSize * scale / 2.0f;
            if (low != x && !Float.isInfinite(low)) {
                g.draw(new Line2D.Float(low, y - halfcap, low, y + halfcap));
            }
            if (high != x && !Float.isInfinite(high)) {
                g.draw(new Line2D.Float(high, y - halfcap, high, y + halfcap));
            }
        }
    }

    private void drawErrorBarY(Graphics2D g, float x, float y, float low, float high, float scale) {
        if (!Float.isInfinite(low) && !Float.isInfinite(high)) {
            g.draw(new Line2D.Float(x, low, x, high));
        } else {
            float ah;
            float head;
            float tail;
            if (low == Float.POSITIVE_INFINITY) {
                tail = high == Float.NEGATIVE_INFINITY ? y : high;
                head = y > high ? y + 12.0f * scale : high + 12.0f * scale;
                g.draw(new Line2D.Float(x, tail, x, head));
                ah = 3.0f * scale;
                g.draw(new Line2D.Float(x, head, x - ah, head - ah));
                g.draw(new Line2D.Float(x, head, x + ah, head - ah));
            }
            if (high == Float.NEGATIVE_INFINITY) {
                tail = low == Float.POSITIVE_INFINITY ? y : low;
                head = y < low ? y - 12.0f * scale : low - 12.0f * scale;
                g.draw(new Line2D.Float(x, tail, x, head));
                ah = 3.0f * scale;
                g.draw(new Line2D.Float(x, head, x - ah, head + ah));
                g.draw(new Line2D.Float(x, head, x + ah, head + ah));
            }
        }
        if (this.errorbarCapSize > 0.0f) {
            float halfcap = this.errorbarCapSize * scale / 2.0f;
            if (low != y && !Float.isInfinite(low)) {
                g.draw(new Line2D.Float(x - halfcap, low, x + halfcap, low));
            }
            if (high != y && !Float.isInfinite(high)) {
                g.draw(new Line2D.Float(x - halfcap, high, x + halfcap, high));
            }
        }
    }

    static void drawLine(Graphics2D g, float[] xout, float[] yout, int lsize, XYGraphEx graph, double scale) {
        g.setStroke(GraphicsUtil.scaleStroke(graph.getLineStroke(), scale));
        Path2D.Float gp = new Path2D.Float();
        gp.moveTo(xout[0], yout[0]);
        for (int i = 1; i < lsize; ++i) {
            gp.lineTo(xout[i], yout[i]);
        }
        g.draw(gp);
    }

    private static void drawHistogram(Graphics2D g, XYGraphDataChunker.ChunkData data, XYGraphEx graph, double scale) {
        float[] x = data.xBuf;
        float[] y = data.yBuf;
        int lsize = data.size;
        int nsize = lsize * 2;
        float[] xout = new float[nsize];
        float[] yout = new float[nsize];
        xout[0] = x[0];
        yout[0] = y[0];
        int j = 1;
        int a = 0;
        for (int b = 1; b < lsize; ++b) {
            float xm;
            xout[j] = xm = (x[a] + x[b]) / 2.0f;
            yout[j] = y[a];
            xout[++j] = xm;
            yout[j] = y[b];
            ++j;
            ++a;
        }
        xout[j] = x[lsize - 1];
        yout[j] = y[lsize - 1];
        XYGraphImpl.drawLine(g, xout, yout, nsize, graph, scale);
    }

    private static void drawEdgeHistogram(Graphics2D g, float[] x, float[] y, int lsize, XYGraphEx graph, double scale) {
        int nsize = lsize * 2 - 1;
        float[] xout = new float[nsize];
        float[] yout = new float[nsize];
        int hi = 0;
        for (int i = 0; i < lsize - 1; ++i) {
            xout[hi] = x[i];
            yout[hi] = y[i];
            xout[++hi] = x[i + 1];
            yout[hi] = y[i];
            ++hi;
        }
        xout[hi] = x[lsize - 1];
        yout[hi] = y[lsize - 1];
        XYGraphImpl.drawLine(g, xout, yout, nsize, graph, scale);
    }

    static void drawMarks(Graphics2D g, float[] xp, float[] yp, int npoints, XYGraphEx graph, Color[] colors, double scale) {
        double lw = (double)graph.getLineStroke().getLineWidth() * scale / 2.0;
        g.setStroke(new BasicStroke((float)lw, 0, 0));
        SymbolShape ss = graph.getSymbolShape();
        for (int i = 0; i < npoints; ++i) {
            if (colors[i] == null) continue;
            g.setColor(colors[i]);
            double safScale = scale * (double)graph.getSymbolSize();
            AffineTransform maf = AffineTransform.getTranslateInstance(xp[i], yp[i]);
            maf.scale(safScale, -safScale);
            ss.draw(g, maf);
        }
    }
}

