/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.VLineAnnotationEx;
import org.jplot2d.transform.PaperTransform;
import org.jplot2d.util.DoubleDimension2D;

public class VLineAnnotationImpl
extends AnnotationImpl
implements VLineAnnotationEx {
    private double valueX;
    private BasicStroke stroke = DEFAULT_STROKE;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "VLineAnnotation" + this.getParent().indexOf(this);
        }
        return "VLineAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getXAxisTransform() == null) {
            return null;
        }
        double locX = this.getXWtoP(this.valueX);
        return new Point2D.Double(locX, 0.0);
    }

    @Override
    public void setLocation(double x, double y) {
        Point2D loc = this.getLocation();
        if (loc != null && loc.getX() != x) {
            this.valueX = this.getXPtoW(x);
            VLineAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null || this.getParent().getSize() == null) {
            return null;
        }
        return new DoubleDimension2D(this.getParent().getSize().getHeight(), 0.0);
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null) {
            return null;
        }
        double lineWidth = 0.0;
        if (this.stroke instanceof BasicStroke) {
            lineWidth = this.stroke.getLineWidth();
        }
        if (lineWidth < 2.0) {
            lineWidth = 2.0;
        }
        return new Rectangle2D.Double(0.0, -lineWidth / 2.0, this.getParent().getSize().getHeight(), lineWidth);
    }

    @Override
    public PaperTransform getPaperTransform() {
        PaperTransform pxf = super.getPaperTransform();
        if (pxf == null) {
            return null;
        }
        return pxf.rotate(1.5707963267948966);
    }

    @Override
    public double getValue() {
        return this.valueX;
    }

    @Override
    public void setValue(double value) {
        this.valueX = value;
        VLineAnnotationImpl.redraw(this);
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        VLineAnnotationImpl.redraw(this);
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        AffineTransform oldTransform = g.getTransform();
        Shape oldClip = g.getClip();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.setColor(this.getEffectiveColor());
        g.setStroke(this.stroke);
        Line2D.Double line = new Line2D.Double(loc.getX(), 0.0, loc.getX(), this.getParent().getSize().getHeight());
        g.draw(line);
        g.setTransform(oldTransform);
        g.setClip(oldClip);
        g.setStroke(oldStroke);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        VLineAnnotationImpl lm = (VLineAnnotationImpl)src;
        this.valueX = lm.valueX;
        this.stroke = lm.stroke;
    }
}

