/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jplot2d.element.impl.AnnotationImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.HLineAnnotationEx;
import org.jplot2d.util.DoubleDimension2D;

public class HLineAnnotationImpl
extends AnnotationImpl
implements HLineAnnotationEx {
    private double valueY;
    private BasicStroke stroke = DEFAULT_STROKE;

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "HLineAnnotation" + this.getParent().indexOf(this);
        }
        return "HLineAnnotation@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public Point2D getLocation() {
        if (this.getParent() == null || this.getParent().getSize() == null || this.getParent().getYAxisTransform() == null) {
            return null;
        }
        double locY = this.getYWtoP(this.valueY);
        return new Point2D.Double(0.0, locY);
    }

    @Override
    public void setLocation(double x, double y) {
        Point2D loc = this.getLocation();
        if (loc != null && loc.getY() != y) {
            this.valueY = this.getYPtoW(y);
            HLineAnnotationImpl.redraw(this);
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.getParent() == null || this.getParent().getSize() == null) {
            return null;
        }
        return new DoubleDimension2D(this.getParent().getSize().getWidth(), 0.0);
    }

    @Override
    public Rectangle2D getSelectableBounds() {
        if (this.getParent() == null || this.getParent().getSize() == null) {
            return null;
        }
        double lineWidth = 0.0;
        if (this.stroke instanceof BasicStroke) {
            lineWidth = this.stroke.getLineWidth();
        }
        if (lineWidth < 2.0) {
            lineWidth = 2.0;
        }
        return new Rectangle2D.Double(0.0, -lineWidth / 2.0, this.getParent().getSize().getWidth(), lineWidth);
    }

    @Override
    public double getValue() {
        return this.valueY;
    }

    @Override
    public void setValue(double value) {
        this.valueY = value;
        HLineAnnotationImpl.redraw(this);
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        HLineAnnotationImpl.redraw(this);
    }

    @Override
    public void draw(Graphics2D g) {
        Point2D loc = this.getLocation();
        if (loc == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        AffineTransform oldTransform = g.getTransform();
        Shape oldClip = g.getClip();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.setClip(this.getParent().getBounds());
        g.setColor(this.getEffectiveColor());
        g.setStroke(this.stroke);
        Line2D.Double line = new Line2D.Double(0.0, loc.getY(), this.getParent().getSize().getWidth(), loc.getY());
        g.draw(line);
        g.setTransform(oldTransform);
        g.setClip(oldClip);
        g.setStroke(oldStroke);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        HLineAnnotationImpl lm = (HLineAnnotationImpl)src;
        this.valueY = lm.valueY;
        this.stroke = lm.stroke;
    }
}

