/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.geom.Point2D;
import java.util.Locale;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.Plot;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.CoordinateAnnotationEx;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.SymbolAnnotationImpl;
import org.jplot2d.tex.MathElement;
import org.jplot2d.util.NumberUtils;

public class CoordinateAnnotationImpl
extends SymbolAnnotationImpl
implements CoordinateAnnotationEx {
    public CoordinateAnnotationImpl() {
        this.setVAlign(VAlign.TOP);
        this.setTextOffsetFactorX(0.8f);
        this.setTextOffsetFactorY(-0.8f);
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            return "ValuePicker" + this.getParent().indexOf(this);
        }
        return "ValuePicker@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public MathElement getTextModel() {
        Plot plot;
        if (this.textModel != null) {
            return this.textModel;
        }
        LayerEx layer = this.getParent();
        Plot plot2 = plot = layer == null ? null : layer.getParent();
        if (plot == null) {
            return null;
        }
        Point2D loc = this.getLocation();
        if (loc == null) {
            return null;
        }
        Point2D.Double p = (Point2D.Double)plot.getPaperTransform().getPtoD(loc);
        AxisTransform xat = layer.getXAxisTransform();
        double nx = plot.getPaperTransform().getXDtoP(p.x) / plot.getContentSize().getWidth();
        double nxL = plot.getPaperTransform().getXDtoP(p.x - 1.0) / plot.getContentSize().getWidth();
        double nxH = plot.getPaperTransform().getXDtoP(p.x + 1.0) / plot.getContentSize().getWidth();
        double vx = xat.getNormalTransform().convFromNR(nx);
        double deltaXL = Math.abs(xat.getNormalTransform().convFromNR(nxL) - vx);
        double deltaXH = Math.abs(xat.getNormalTransform().convFromNR(nxH) - vx);
        String xformat = NumberUtils.calcDeltaFormatStr(vx, Math.min(deltaXL, deltaXH) / 2.0);
        AxisTransform yat = layer.getYAxisTransform();
        double ny = plot.getPaperTransform().getYDtoP(p.y) / plot.getContentSize().getHeight();
        double nyL = plot.getPaperTransform().getYDtoP(p.y - 1.0) / plot.getContentSize().getHeight();
        double nyH = plot.getPaperTransform().getYDtoP(p.y + 1.0) / plot.getContentSize().getHeight();
        double vy = xat.getNormalTransform().convFromNR(ny);
        double deltaYL = Math.abs(yat.getNormalTransform().convFromNR(nyL) - vy);
        double deltaYH = Math.abs(yat.getNormalTransform().convFromNR(nyH) - vy);
        String yformat = NumberUtils.calcDeltaFormatStr(vy, Math.min(deltaYL, deltaYH) / 2.0);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format((Locale)null, xformat, vx));
        sb.append(", ");
        sb.append(String.format((Locale)null, yformat, vy));
        this.setText(sb.toString());
        return this.textModel;
    }

    @Override
    public void setValuePoint(double x, double y) {
        super.setValuePoint(x, y);
        this.setTextModel(null);
    }
}

