/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.Plot;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisTitleEx;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabel;
import org.jplot2d.tex.TeXMathUtils;
import org.jplot2d.util.DoubleDimension2D;

public class AxisTitleImpl
extends ElementImpl
implements AxisTitleEx {
    private boolean visible = true;
    private Color color = null;
    private String fontName;
    private int fontStyle = -1;
    private float fontSize = Float.NaN;
    private float fontScale = 1.5f;
    private VAlign vAlign;
    private MathElement textModel;
    private MathLabel label;

    @Override
    public String getId() {
        return "Title";
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = Plot.class.getMethod("getTitle", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public AxisEx getParent() {
        return (AxisEx)this.parent;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.invalidateThickness();
        this.redraw();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        Color oldColor = this.getEffectiveColor();
        this.color = color;
        if (this.isVisible() && !this.getEffectiveColor().equals(oldColor)) {
            this.redraw();
        }
    }

    private Color getEffectiveColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveColor();
        }
        return null;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String name) {
        String oldFontName = this.getEffectiveFontName();
        this.fontName = name;
        if (!this.getEffectiveFontName().equals(oldFontName)) {
            this.updateFont();
        }
    }

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public void setFontStyle(int style) {
        int oldStyle = this.getEffectiveFontStyle();
        this.fontStyle = style;
        if (this.getEffectiveFontStyle() != oldStyle) {
            this.updateFont();
        }
    }

    @Override
    public float getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(float size) {
        float oldSize = this.getEffectiveFontSize();
        this.fontSize = size;
        if (this.getEffectiveFontSize() != oldSize) {
            this.updateFont();
        }
    }

    @Override
    public float getFontScale() {
        return this.fontScale;
    }

    @Override
    public void setFontScale(float scale) {
        float oldSize = this.getEffectiveFontSize();
        this.fontScale = scale;
        if (this.getEffectiveFontSize() != oldSize) {
            this.updateFont();
        }
    }

    @Override
    public void setFont(Font font) {
        Font oldFont = this.getEffectiveFont();
        if (font == null) {
            this.fontName = null;
            this.fontStyle = -1;
            this.fontSize = Float.NaN;
        } else {
            this.fontName = font.getName();
            this.fontStyle = font.getStyle();
            this.fontSize = font.getSize2D();
        }
        if (!this.getEffectiveFont().equals(oldFont)) {
            this.updateFont();
        }
    }

    private void updateFont() {
        this.label = null;
        if (this.isVisible()) {
            this.invalidateThickness();
            this.redraw();
        }
    }

    private String getEffectiveFontName() {
        if (this.fontName != null) {
            return this.fontName;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontName();
        }
        return null;
    }

    private int getEffectiveFontStyle() {
        if ((this.fontStyle & 0xFFFFFFFC) == 0) {
            return this.fontStyle;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontStyle();
        }
        return -1;
    }

    private float getEffectiveFontSize() {
        if (!Float.isNaN(this.fontSize)) {
            return this.fontSize;
        }
        if (this.getParent() != null) {
            return this.getParent().getEffectiveFontSize() * this.fontScale;
        }
        return Float.NaN;
    }

    @Override
    public Font getEffectiveFont() {
        float size = this.getEffectiveFontSize();
        return new Font(this.getEffectiveFontName(), this.getEffectiveFontStyle(), (int)size).deriveFont(size);
    }

    @Override
    public String getText() {
        return TeXMathUtils.toString(this.textModel);
    }

    @Override
    public void setText(String text) {
        this.setTextModel(TeXMathUtils.parseText(text));
    }

    @Override
    public MathElement getTextModel() {
        return this.textModel;
    }

    @Override
    public void setTextModel(MathElement model) {
        this.textModel = model;
        this.label = null;
        if (this.isVisible()) {
            this.invalidateThickness();
            this.redraw();
        }
    }

    private void invalidateThickness() {
        if (this.getParent() != null) {
            this.getParent().invalidateThickness();
        }
    }

    private void redraw() {
        if (this.getParent() != null) {
            ComponentImpl.redraw(this.getParent());
        }
    }

    @Override
    public void setVAlign(VAlign vAlign) {
        if (this.vAlign != vAlign) {
            this.vAlign = vAlign;
            this.label = null;
            if (this.isVisible()) {
                this.redraw();
            }
        }
    }

    @Override
    public Dimension2D getSize() {
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.vAlign, HAlign.CENTER);
        }
        Rectangle2D bounds = this.label.getBounds();
        return new DoubleDimension2D(bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public void draw(Graphics2D g, double x, double y) {
        if (this.label == null) {
            this.label = new MathLabel(this.getTextModel(), this.getEffectiveFont(), this.vAlign, HAlign.CENTER);
        }
        AffineTransform oldTransform = g.getTransform();
        g.transform(this.getParent().getPaperTransform().getTransform());
        g.translate(x, y);
        g.scale(1.0, -1.0);
        g.setColor(this.getEffectiveColor());
        this.label.draw(g);
        g.setTransform(oldTransform);
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        AxisTitleImpl tc = (AxisTitleImpl)src;
        this.visible = tc.visible;
        this.color = tc.color;
        this.fontName = tc.fontName;
        this.fontStyle = tc.fontStyle;
        this.fontSize = tc.fontSize;
        this.fontScale = tc.fontScale;
        this.vAlign = tc.vAlign;
        this.textModel = tc.textModel;
        this.label = tc.label;
    }
}

