/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jplot2d.data.GraphData;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.GraphEx;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.PrecisionState;
import org.jplot2d.element.impl.RangeStatus;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.util.Range;

public class AxisRangeUtils {
    protected static final double PRECISIONLIMIT = 1.4551915228366852E-11;
    protected static final double DIGI4LIMIT = 0.004;

    private AxisRangeUtils() {
    }

    private static Range getBounds(Map<AxisTransformEx, NormalTransform> vtMap) {
        Range pbnds = new Range.Double(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (Map.Entry<AxisTransformEx, NormalTransform> me : vtMap.entrySet()) {
            AxisTransformEx ax = me.getKey();
            Range aprange = me.getValue().convToNR(ax.getType().getBoundary(ax.getTransform()));
            pbnds = ((Range)pbnds).intersect(aprange);
        }
        return pbnds;
    }

    public static Map<AxisTransformEx, NormalTransform> createVirtualTransformMap(Collection<AxisTransformEx> axes) {
        if (axes.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<AxisTransformEx, NormalTransform> result = new HashMap<AxisTransformEx, NormalTransform>();
        boolean match = false;
        double offset = Double.NaN;
        for (AxisTransformEx axis : axes) {
            if (!match) {
                offset = axis.getNormalTransform().getOffset();
                match = true;
                continue;
            }
            if (axis.getNormalTransform().getOffset() == offset) continue;
            match = false;
            break;
        }
        if (match) {
            for (AxisTransformEx axis : axes) {
                NormalTransform nx = axis.getNormalTransform().deriveNoOffset();
                result.put(axis, nx);
            }
        } else {
            for (AxisTransformEx axis : axes) {
                NormalTransform nx = axis.getNormalTransform();
                result.put(axis, nx);
            }
        }
        return result;
    }

    public static Map<AxisTransformEx, NormalTransform> createNormalTransformMap(Collection<AxisTransformEx> axes) {
        LinkedHashMap<AxisTransformEx, NormalTransform> vtMap = new LinkedHashMap<AxisTransformEx, NormalTransform>();
        for (AxisTransformEx axis : axes) {
            vtMap.put(axis, axis.getNormalTransform());
        }
        return vtMap;
    }

    public static RangeStatus<Boolean> calcNiceVirtualRange(Map<AxisTransformEx, NormalTransform> vtMap) {
        Range pbnds = new Range.Double(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        for (AxisTransformEx ax : vtMap.keySet()) {
            Range aprange = vtMap.get(ax).convToNR(ax.getType().getBoundary(ax.getTransform()));
            pbnds = ((Range)pbnds).intersect(aprange);
        }
        if (pbnds == null) {
            return null;
        }
        Range padRange = null;
        boolean dataOutsideBounds = false;
        for (AxisTransformEx at : vtMap.keySet()) {
            for (LayerEx layer : at.getLayers()) {
                GraphData dataInBounds;
                Range urange = vtMap.get(at).convFromNR(pbnds);
                Range wDRange = new Range.Double();
                if (layer.getXAxisTransform() == at) {
                    AxisTransformEx yat = layer.getYAxisTransform();
                    Range yRange = yat.getLockGroup().isAutoRange() ? yat.getType().getBoundary(yat.getTransform()) : yat.getRange();
                    for (GraphEx dp : layer.getGraphs()) {
                        if (dp.getData() == null) continue;
                        dataInBounds = dp.getData().applyBoundary(urange, yRange);
                        wDRange = dataInBounds.getXRange().union(wDRange);
                        if (!dataInBounds.hasPointOutsideXBounds()) continue;
                        dataOutsideBounds = true;
                    }
                } else if (layer.getYAxisTransform() == at) {
                    AxisTransformEx xat = layer.getXAxisTransform();
                    Range xRange = xat.getLockGroup().isAutoRange() ? xat.getType().getBoundary(xat.getTransform()) : xat.getRange();
                    for (GraphEx dp : layer.getGraphs()) {
                        if (dp.getData() == null) continue;
                        dataInBounds = dp.getData().applyBoundary(xRange, urange);
                        wDRange = dataInBounds.getYRange().union(wDRange);
                        if (!dataInBounds.hasPointOutsideYBounds()) continue;
                        dataOutsideBounds = true;
                    }
                }
                if (((Range)wDRange).isEmpty()) continue;
                Range pDRange = vtMap.get(at).convToNR(wDRange);
                double pLo = pDRange.getMin();
                double pHi = pDRange.getMax();
                double span = pDRange.getSpan();
                Range pXdRange = new Range.Double(pLo -= span * at.getMarginFactor(), pHi += span * at.getMarginFactor()).intersect(pbnds);
                padRange = padRange == null ? pXdRange : padRange.union(pXdRange);
            }
        }
        if (padRange == null) {
            return null;
        }
        return new RangeStatus<Boolean>(padRange.getMin(), padRange.getMax(), dataOutsideBounds);
    }

    public static Range validateNormalRange(Range range, Collection<AxisTransformEx> axes, boolean findNearsetData) {
        Map<AxisTransformEx, NormalTransform> axisMap = AxisRangeUtils.createNormalTransformMap(axes);
        return AxisRangeUtils.validateNormalRange(range, axisMap, findNearsetData);
    }

    public static Range validateNormalRange(Range range, Map<AxisTransformEx, NormalTransform> axisMap, boolean findNearsetData) {
        if (range.isInverted()) {
            throw new IllegalArgumentException();
        }
        Range pbnds = new Range.Double(range);
        for (Map.Entry<AxisTransformEx, NormalTransform> me : axisMap.entrySet()) {
            AxisTransformEx ax = me.getKey();
            Range aprange = me.getValue().convToNR(me.getKey().getType().getBoundary(ax.getTransform()));
            pbnds = ((Range)pbnds).intersect(aprange);
        }
        if (pbnds == null) {
            return null;
        }
        for (Map.Entry<AxisTransformEx, NormalTransform> me : axisMap.entrySet()) {
            Range urange = me.getValue().convFromNR(pbnds);
            AxisTransformEx ax = me.getKey();
            if ((urange = urange.intersect(ax.getType().getBoundary(ax.getTransform()))) != null) continue;
            return null;
        }
        boolean findLoData = false;
        boolean findHiData = false;
        if (findNearsetData) {
            for (Map.Entry<AxisTransformEx, NormalTransform> me : axisMap.entrySet()) {
                Range urange = me.getValue().convFromNR(range);
                AxisTransformEx ax = me.getKey();
                if (urange.getStart() < ax.getType().getBoundary(ax.getTransform()).getStart()) {
                    findLoData = true;
                }
                if (!(urange.getEnd() > ax.getType().getBoundary(ax.getTransform()).getEnd())) continue;
                findHiData = true;
            }
        } else {
            findLoData = range.getStart() == Double.NEGATIVE_INFINITY;
            boolean bl = findHiData = range.getStart() == Double.POSITIVE_INFINITY;
        }
        if (findLoData || findHiData) {
            pbnds = AxisRangeUtils.findDataRange(pbnds, axisMap, findLoData, findHiData);
        }
        if (pbnds == null) {
            return null;
        }
        return pbnds;
    }

    private static Range findDataRange(Range pbnds, Map<AxisTransformEx, NormalTransform> axisMap, boolean findLoData, boolean findHiData) {
        Range padRange = null;
        for (Map.Entry<AxisTransformEx, NormalTransform> me : axisMap.entrySet()) {
            double pLo = Double.POSITIVE_INFINITY;
            double pHi = Double.NEGATIVE_INFINITY;
            AxisTransformEx arm = me.getKey();
            NormalTransform vnt = me.getValue();
            Range urange = vnt.convFromNR(pbnds);
            urange = urange.intersect(arm.getType().getBoundary(arm.getTransform()));
            for (LayerEx layer : arm.getLayers()) {
                Range wDRange = new Range.Double();
                if (layer.getXAxisTransform() == arm) {
                    for (GraphEx dp : layer.getGraphs()) {
                        if (dp.getData() == null) continue;
                        wDRange = dp.getData().applyBoundary(urange, null).getXRange().union(wDRange);
                    }
                } else if (layer.getYAxisTransform() == arm) {
                    for (GraphEx dp : layer.getGraphs()) {
                        if (dp.getData() == null) continue;
                        wDRange = dp.getData().applyBoundary(null, urange).getYRange().union(wDRange);
                    }
                }
                if (wDRange == null) continue;
                Range pDRange = vnt.convToNR(wDRange);
                if (pLo > pDRange.getMin()) {
                    pLo = pDRange.getMin();
                }
                if (!(pHi < pDRange.getMax())) continue;
                pHi = pDRange.getMax();
            }
            if (!findLoData) {
                pLo = pbnds.getStart();
            }
            if (!findHiData) {
                pHi = pbnds.getEnd();
            }
            Range pXdRange = null;
            if (pLo == pHi) {
                pXdRange = new Range.Double(pLo, pHi);
            } else if (pLo < pHi) {
                if (arm.getTransform() == vnt.getType()) {
                    double span = pHi - pLo;
                    pXdRange = new Range.Double(pLo -= span * arm.getMarginFactor(), pHi += span * arm.getMarginFactor());
                } else {
                    Range wr = vnt.convFromNR(new Range.Double(pLo, pHi));
                    NormalTransform npt = arm.getTransform().createNormalTransform(wr);
                    Range.Double exnpr = new Range.Double(-arm.getMarginFactor(), 1.0 + arm.getMarginFactor());
                    Range exwr = npt.convFromNR(exnpr);
                    pXdRange = vnt.convToNR(exwr);
                }
            }
            if (pXdRange == null) continue;
            pXdRange = ((Range)pXdRange).intersect(pbnds);
            if (padRange == null) {
                padRange = pXdRange;
                continue;
            }
            padRange = padRange.union(pXdRange);
        }
        if (padRange == null) {
            return null;
        }
        return new Range.Double(findLoData ? padRange.getMin() : pbnds.getStart(), findHiData ? padRange.getMax() : pbnds.getEnd());
    }

    public static RangeStatus<PrecisionState> ensurePrecision(Range prange, Collection<AxisTransformEx> axes) {
        Map<AxisTransformEx, NormalTransform> axisMap = AxisRangeUtils.createNormalTransformMap(axes);
        return AxisRangeUtils.ensurePrecision(prange, axisMap);
    }

    public static RangeStatus<PrecisionState> ensurePrecision(Range prange, Map<AxisTransformEx, NormalTransform> vtMap) {
        double pHi;
        double pLo = prange.getStart();
        if (pLo > (pHi = prange.getEnd())) {
            throw new IllegalArgumentException("pLo > pHi is not allowed.");
        }
        double precisionLimit = pHi == pLo ? 0.004 : 1.4551915228366852E-11;
        PrecisionState ex = null;
        double minRange = 0.0;
        String minRangeId = null;
        for (Map.Entry<AxisTransformEx, NormalTransform> me : vtMap.entrySet()) {
            AxisTransformEx axis = me.getKey();
            NormalTransform vt = me.getValue();
            double r = vt.getMinPSpan4PrecisionLimit(pLo, pHi, precisionLimit);
            if (!(minRange < r)) continue;
            minRange = r;
            minRangeId = axis.getFullId();
        }
        if (pHi == pLo && minRange == 0.0) {
            double minScale = Double.POSITIVE_INFINITY;
            for (Map.Entry<AxisTransformEx, NormalTransform> me : vtMap.entrySet()) {
                NormalTransform vt = me.getValue();
                double ascale = Math.abs(vt.getScale());
                if (!(minScale > ascale)) continue;
                minScale = ascale;
            }
            minRange = 0.004 / minScale;
        }
        double span = Double.NaN;
        if (minRange > pHi - pLo) {
            span = minRange;
            double avg = (pLo + pHi) / 2.0;
            pLo = avg - minRange / 2.0;
            pHi = avg + minRange / 2.0;
            ex = new PrecisionState("The range has been adjusted to satisfy the precision limit for axis " + minRangeId);
        }
        if (ex != null) {
            Range bnds = AxisRangeUtils.getBounds(vtMap);
            if (bnds.getSpan() < span) {
                pLo = bnds.getStart();
                pHi = bnds.getEnd();
            } else if (!bnds.contains(pLo)) {
                pLo = bnds.getStart();
                pHi = pLo + span;
            } else if (!bnds.contains(pHi)) {
                pHi = bnds.getEnd();
                pLo = pHi - span;
            }
        }
        RangeStatus<Object> result = new RangeStatus<Object>(pLo, pHi, ex);
        return result;
    }

    public static RangeStatus<PrecisionState> ensureCircleSpan(Range prange, Collection<AxisTransformEx> axes) {
        Map<AxisTransformEx, NormalTransform> vtMap = AxisRangeUtils.createNormalTransformMap(axes);
        return AxisRangeUtils.ensureCircleSpan(prange, vtMap);
    }

    public static RangeStatus<PrecisionState> ensureCircleSpan(Range prange, Map<AxisTransformEx, NormalTransform> vtMap) {
        double pHi;
        double pLo = prange.getStart();
        if (pLo > (pHi = prange.getEnd())) {
            throw new IllegalArgumentException("pLo > pHi is not allowed.");
        }
        double maxRange = Double.POSITIVE_INFINITY;
        String maxRangeId = null;
        for (Map.Entry<AxisTransformEx, NormalTransform> me : vtMap.entrySet()) {
            AxisTransformEx axis = me.getKey();
            NormalTransform vt = me.getValue();
            if (axis.getType().getCircularRange() == null) continue;
            double ascale = Math.abs(vt.getScale());
            double pcircle = axis.getType().getCircularRange().getSpan() / ascale;
            if (!(maxRange > pcircle)) continue;
            maxRange = pcircle;
            maxRangeId = axis.getFullId();
        }
        PrecisionState ex = null;
        if (maxRange < pHi - pLo) {
            double avg = (pLo + pHi) / 2.0;
            pLo = avg - maxRange / 2.0;
            pHi = avg + maxRange / 2.0;
            ex = new PrecisionState("The range has been adjusted to satisfy the circle limit for axis " + maxRangeId);
        }
        return new RangeStatus<Object>(pLo, pHi, ex);
    }
}

