/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jplot2d.element.AxisTransform;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisRangeLockGroupEx;
import org.jplot2d.element.impl.AxisRangeUtils;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.ElementImpl;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.PrecisionState;
import org.jplot2d.element.impl.RangeStatus;
import org.jplot2d.notice.Notice;
import org.jplot2d.notice.RangeAdjustedToValueBoundsNotice;
import org.jplot2d.notice.RangeSelectionNotice;
import org.jplot2d.transform.NormalTransform;
import org.jplot2d.util.Range;

public class AxisRangeLockGroupImpl
extends ElementImpl
implements AxisRangeLockGroupEx {
    private static Range NORM_PHYSICAL_RANGE = new Range.Double(0.0, 1.0);
    private static Range INFINITY_PHYSICAL_RANGE = new Range.Double(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private AxisTransformEx prim;
    private boolean autoRange = true;
    private boolean zoomable = true;
    private List<AxisTransformEx> arms = new ArrayList<AxisTransformEx>();
    private boolean autoRangeNeeded = true;

    @Override
    public String getId() {
        return "LockGroup@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public String getFullId() {
        return "AxisRangeLockGroup@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.arms.size() == 0) {
            return null;
        }
        try {
            method = AxisTransformEx.class.getMethod("getLockGroup", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method);
    }

    @Override
    public AxisTransformEx getParent() {
        return (AxisTransformEx)super.getParent();
    }

    @Override
    public ElementEx getPrim() {
        return this.prim;
    }

    @Override
    public void notify(Notice msg) {
        if (this.getPrim() != null) {
            this.getPrim().notify(msg);
        }
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        AxisRangeLockGroupImpl alg = (AxisRangeLockGroupImpl)src;
        this.autoRange = alg.autoRange;
        this.zoomable = alg.zoomable;
        this.autoRangeNeeded = alg.autoRangeNeeded;
    }

    @Override
    public int indexOfRangeManager(AxisTransformEx rangeManager) {
        return this.arms.indexOf(rangeManager);
    }

    @Override
    public AxisTransformEx[] getRangeManagers() {
        return this.arms.toArray(new AxisTransformEx[this.arms.size()]);
    }

    @Override
    public void addRangeManager(AxisTransformEx axis) {
        this.arms.add(axis);
        if (this.arms.size() == 1) {
            this.parent = axis;
            this.prim = axis;
        } else {
            this.parent = null;
            this.autoRange = false;
        }
    }

    @Override
    public void removeRangeManager(AxisTransformEx axis) {
        this.arms.remove(axis);
        this.autoRange = false;
        if (this.arms.size() == 0) {
            this.parent = null;
            this.prim = null;
        } else if (this.arms.size() == 1) {
            this.parent = this.arms.get(0);
            this.prim = this.arms.get(0);
        } else {
            this.parent = null;
            if (this.prim == axis) {
                this.prim = this.arms.get(0);
            }
        }
    }

    @Override
    public AxisTransformEx getPrimaryAxis() {
        return this.prim;
    }

    @Override
    public boolean isAutoRange() {
        return this.autoRange;
    }

    @Override
    public void setAutoRange(boolean autoRange) {
        this.autoRange = autoRange;
        if (autoRange) {
            this.autoRangeNeeded = true;
        }
    }

    @Override
    public boolean isZoomable() {
        return this.zoomable;
    }

    @Override
    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    @Override
    public void reAutoRange() {
        this.autoRange = true;
        this.autoRangeNeeded = true;
    }

    @Override
    public boolean calcAutoRange() {
        if (this.autoRange && this.autoRangeNeeded) {
            this.autoRange();
            this.autoRangeNeeded = false;
            return true;
        }
        return false;
    }

    private void autoRange() {
        Range extRange;
        AxisTransformEx master;
        RangeStatus<PrecisionState> rs;
        Map<AxisTransformEx, NormalTransform> vtMap = AxisRangeUtils.createVirtualTransformMap(this.arms);
        RangeStatus<Boolean> pRange = AxisRangeUtils.calcNiceVirtualRange(vtMap);
        if (pRange == null) {
            this.notify(new RangeSelectionNotice("Axes [" + this.getAxesShortId() + "] contain no valid data, auto range ignored."));
            return;
        }
        if (pRange.getStatus().booleanValue()) {
            this.notify(new RangeAdjustedToValueBoundsNotice("AutoRange only on valid data of axes."));
        }
        if ((rs = AxisRangeUtils.ensurePrecision(pRange, vtMap)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(rs.getStatus().getMessage()));
        }
        if ((master = this.getPrimaryAxis()).isAutoMargin()) {
            Range ur = vtMap.get(master).convFromNR(rs);
            Range exur = master.expandRangeToTick(ur);
            extRange = vtMap.get(master).convToNR(exur);
        } else {
            extRange = rs;
        }
        RangeStatus<PrecisionState> xrs = AxisRangeUtils.ensureCircleSpan(extRange, vtMap);
        if (xrs.getStatus() != null) {
            this.notify(new RangeSelectionNotice(xrs.getStatus().getMessage()));
        }
        this.zoomVirtualRange(xrs, vtMap);
        this.autoRange = true;
    }

    @Override
    public void zoomVirtualRange(Range range, Map<AxisTransformEx, NormalTransform> vtMap) {
        for (AxisTransformEx arm : this.arms) {
            NormalTransform vt = vtMap.get(arm).zoom(range);
            Range wrange = vt.getValueRange();
            if (arm.getRange().equals(wrange)) continue;
            arm.setNormalTransfrom(arm.getTransform().createNormalTransform(wrange));
        }
        this.autoRange = false;
    }

    @Override
    public void zoomRange(double start, double end) {
        RangeStatus<PrecisionState> xrs;
        RangeStatus<PrecisionState> rs;
        Range.Double range = new Range.Double(start, end);
        Range validRange = AxisRangeUtils.validateNormalRange((Range)range, this.arms, false);
        if (!validRange.equals(range)) {
            this.notify(new RangeAdjustedToValueBoundsNotice("Range exceed valid boundary, has been adjusted."));
        }
        if ((rs = AxisRangeUtils.ensurePrecision(validRange, this.arms)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(rs.getStatus().getMessage()));
        }
        if ((xrs = AxisRangeUtils.ensureCircleSpan(rs, this.arms)).getStatus() != null) {
            this.notify(new RangeSelectionNotice(xrs.getStatus().getMessage()));
        }
        this.zoomNormalRange(xrs);
    }

    @Override
    public void zoomNormalRange(Range npRange) {
        for (AxisTransformEx axis : this.arms) {
            NormalTransform npt = axis.getNormalTransform().zoom(npRange);
            axis.setNormalTransfrom(npt);
        }
        this.autoRange = false;
    }

    @Override
    public void validateAxesRange() {
        Range pRange = AxisRangeUtils.validateNormalRange(NORM_PHYSICAL_RANGE, this.arms, true);
        if (pRange == null) {
            pRange = AxisRangeUtils.validateNormalRange(INFINITY_PHYSICAL_RANGE, this.arms, true);
        }
        if (pRange == null) {
            for (AxisTransformEx ax : this.arms) {
                Range defaultWRange = ax.getType().getDefaultWorldRange(ax.getTransform());
                Range nwr = ax.isInverted() ? defaultWRange.invert() : defaultWRange;
                ax.setNormalTransfrom(ax.getTransform().createNormalTransform(nwr));
            }
            this.notify(new RangeAdjustedToValueBoundsNotice("All axes contain no valid data, range set to default range."));
            return;
        }
        if (pRange.getSpan() == 0.0) {
            for (AxisTransformEx ax : this.arms) {
                Range defaultWRange = ax.getType().getDefaultWorldRange(ax.getTransform());
                Range nwr = ax.isInverted() ? defaultWRange.invert() : defaultWRange;
                ax.setNormalTransfrom(ax.getTransform().createNormalTransform(nwr));
            }
            Range pr = AxisRangeUtils.validateNormalRange(INFINITY_PHYSICAL_RANGE, this.arms, true);
            RangeStatus<PrecisionState> rs = AxisRangeUtils.ensurePrecision(pr, this.arms);
            Range ur = this.prim.getNormalTransform().convFromNR(rs);
            Range exur = this.prim.expandRangeToTick(ur);
            Range expr = this.prim.getNormalTransform().convToNR(exur);
            RangeStatus<PrecisionState> xrs = AxisRangeUtils.ensureCircleSpan(expr, this.arms);
            this.zoomNormalRange(xrs);
            this.notify(new RangeSelectionNotice("The axis contains only one valid date."));
            return;
        }
        for (AxisTransformEx ax : this.arms) {
            Range wr = ax.getNormalTransform().convFromNR(pRange);
            ax.setNormalTransfrom(ax.getTransform().createNormalTransform(wr));
        }
        if (this.isAutoRange()) {
            this.reAutoRange();
        } else {
            AxisTransform coreAxis = null;
            Range coreRange = null;
            for (AxisTransformEx ax : this.arms) {
                if (ax.getCoreRange() == null) continue;
                coreAxis = ax;
                coreRange = ax.getCoreRange();
                break;
            }
            if (coreAxis != null) {
                coreAxis.setCoreRange(coreRange);
            } else {
                RangeStatus<PrecisionState> xrs;
                RangeStatus<PrecisionState> rs;
                if (!pRange.equals(NORM_PHYSICAL_RANGE)) {
                    this.notify(new RangeAdjustedToValueBoundsNotice("Some axes contain invalid value, range adjusted."));
                }
                if ((rs = AxisRangeUtils.ensurePrecision(NORM_PHYSICAL_RANGE, this.arms)).getStatus() != null) {
                    this.notify(new RangeSelectionNotice(rs.getStatus().getMessage()));
                }
                if ((xrs = AxisRangeUtils.ensureCircleSpan(rs, this.arms)).getStatus() != null) {
                    this.notify(new RangeSelectionNotice(xrs.getStatus().getMessage()));
                }
                this.zoomNormalRange(xrs);
            }
        }
    }

    private String getAxesShortId() {
        StringBuilder sb = new StringBuilder();
        for (AxisTransformEx rm : this.arms) {
            for (AxisTickManagerEx tm : rm.getTickManagers()) {
                for (AxisEx axis : tm.getAxes()) {
                    sb.append(axis.getShortId());
                    sb.append(", ");
                }
            }
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }
}

