/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jplot2d.element.AxisLabelSide;
import org.jplot2d.element.AxisOrientation;
import org.jplot2d.element.AxisPosition;
import org.jplot2d.element.AxisTickManager;
import org.jplot2d.element.AxisTickSide;
import org.jplot2d.element.Element;
import org.jplot2d.element.HAlign;
import org.jplot2d.element.Plot;
import org.jplot2d.element.VAlign;
import org.jplot2d.element.impl.AxisEx;
import org.jplot2d.element.impl.AxisTickManagerEx;
import org.jplot2d.element.impl.AxisTitleEx;
import org.jplot2d.element.impl.AxisTitleImpl;
import org.jplot2d.element.impl.AxisTransformEx;
import org.jplot2d.element.impl.ComponentEx;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.ElementEx;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LayerEx;
import org.jplot2d.element.impl.PlotEx;
import org.jplot2d.tex.MathElement;
import org.jplot2d.tex.MathLabel;
import org.jplot2d.transform.PaperTransform;
import org.jplot2d.util.DoubleDimension2D;

public class AxisImpl
extends ComponentImpl
implements AxisEx {
    private static final float DEFAULT_AXISLINE_WIDTH = 1.0f;
    private static final double LABEL_GAP_RATIO = 0.25;
    private static final double TITLE_GAP_RATIO = 0.25;
    private final AxisTitleEx title;
    private AxisTickManagerEx tickManager;
    private double locX;
    private double locY;
    private AxisOrientation orientation;
    private double length;
    private AxisPosition position = AxisPosition.NEGATIVE_SIDE;
    private float axisLineWidth = 1.0f;
    private boolean showGridLines;
    private boolean showMinorGridLines;
    private boolean tickVisible = true;
    private AxisTickSide tickSide = AxisTickSide.INWARD;
    private double tickHeight = 8.0;
    private double minorHeight = 4.0;
    private float tickLineWidth = 0.5f;
    private boolean labelVisible = true;
    private AxisOrientation labelOrientation = AxisOrientation.HORIZONTAL;
    private AxisLabelSide labelSide = AxisLabelSide.OUTWARD;
    private Color labelColor;
    private double asc;
    private double desc;
    private double labelOffset;
    private double labelRotation;
    private HAlign labelHAlign;
    private VAlign labelVAlign;
    private double titleOffset;
    private VAlign titleVAlign;
    private boolean thicknessCalculationNeeded = true;
    private Font actualLabelFont;

    public AxisImpl() {
        this.setSelectable(true);
        this.title = new AxisTitleImpl();
        this.title.setParent(this);
    }

    protected AxisImpl(AxisTitleEx title) {
        this.title = title;
    }

    @Override
    public String getId() {
        if (this.getParent() != null) {
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    int xidx = this.getParent().indexOfXAxis(this);
                    return "X" + xidx;
                }
                case VERTICAL: {
                    int yidx = this.getParent().indexOfYAxis(this);
                    return "Y" + yidx;
                }
            }
        }
        return "Axis@" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public String getShortId() {
        if (this.getParent() != null) {
            String pid = this.getParent().getShortId();
            if (pid == null) {
                return this.getId();
            }
            return this.getId() + "." + pid;
        }
        return this.getId();
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        if (this.parent == null) {
            return null;
        }
        try {
            switch (this.getOrientation()) {
                case HORIZONTAL: {
                    Method xmethod = Plot.class.getMethod("getXAxis", Integer.TYPE);
                    return new InvokeStep(xmethod, this.getParent().indexOfXAxis(this));
                }
                case VERTICAL: {
                    Method ymethod = Plot.class.getMethod("getYAxis", Integer.TYPE);
                    return new InvokeStep(ymethod, this.getParent().indexOfYAxis(this));
                }
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    @Override
    public PlotEx getParent() {
        return (PlotEx)super.getParent();
    }

    @Override
    public Map<Element, Element> getMooringMap() {
        AxisTransformEx rman;
        HashMap<Element, Element> result = new HashMap<Element, Element>();
        if (this.tickManager.getParent() == this && (rman = this.tickManager.getAxisTransform()).getParent() == this.tickManager) {
            for (LayerEx layer : rman.getLayers()) {
                result.put(rman, layer);
            }
        }
        return result;
    }

    @Override
    public void thisEffectiveColorChanged() {
        AxisImpl.redraw(this);
    }

    @Override
    public void thisEffectiveFontChanged() {
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(this.locX, this.locY);
    }

    @Override
    public void setLocation(double locX, double locY) {
        if (this.getLocation().getX() != locX || this.getLocation().getY() != locY) {
            this.locX = locX;
            this.locY = locY;
            AxisImpl.redraw(this);
        }
    }

    @Override
    public AxisOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(AxisOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public Dimension2D getSize() {
        if (this.getOrientation() == null) {
            return null;
        }
        switch (this.getOrientation()) {
            case HORIZONTAL: {
                return new DoubleDimension2D(this.getLength(), this.getThickness());
            }
            case VERTICAL: {
                return new DoubleDimension2D(this.getThickness(), this.getLength());
            }
        }
        return null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.getParent() == null) {
            return null;
        }
        return new Rectangle2D.Double(0.0, -this.desc, this.getLength(), this.getThickness());
    }

    @Override
    public PaperTransform getPaperTransform() {
        PaperTransform pxf = super.getPaperTransform();
        if (pxf == null) {
            return null;
        }
        if (this.getOrientation() == AxisOrientation.VERTICAL) {
            pxf = pxf.rotate(1.5707963267948966);
        }
        return pxf;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.invalidatePlot();
    }

    private void invalidatePlot() {
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    @Override
    public AxisTickManagerEx getTickManager() {
        return this.tickManager;
    }

    @Override
    public void setTickManager(AxisTickManager tickManager) {
        if (this.tickManager != null) {
            this.tickManager.removeAxis(this);
        }
        this.tickManager = (AxisTickManagerEx)tickManager;
        if (this.tickManager != null) {
            this.tickManager.addAxis(this);
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public void setLength(double length) {
        if (this.length != length) {
            this.length = length;
            if (this.tickManager.getAxisTransform().getLockGroup().isAutoRange()) {
                this.tickManager.getAxisTransform().getLockGroup().reAutoRange();
            }
        }
    }

    @Override
    public AxisPosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(AxisPosition position) {
        this.position = position;
        this.invalidateThickness();
        this.invalidatePlot();
    }

    @Override
    public float getAxisLineWidth() {
        return this.axisLineWidth;
    }

    @Override
    public void setAxisLineWidth(float width) {
        this.axisLineWidth = width;
        AxisImpl.redraw(this);
    }

    @Override
    public boolean isGridLines() {
        return this.showGridLines;
    }

    @Override
    public void setGridLines(boolean showGridLines) {
        this.showGridLines = showGridLines;
        AxisImpl.redraw(this);
    }

    @Override
    public boolean isMinorGridLines() {
        return this.showMinorGridLines;
    }

    @Override
    public void setMinorGridLines(boolean showGridLines) {
        this.showMinorGridLines = showGridLines;
        AxisImpl.redraw(this);
    }

    @Override
    public boolean isTickVisible() {
        return this.tickVisible;
    }

    @Override
    public void setTickVisible(boolean visible) {
        this.tickVisible = visible;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public AxisTickSide getTickSide() {
        return this.tickSide;
    }

    @Override
    public void setTickSide(AxisTickSide side) {
        this.tickSide = side;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public double getTickHeight() {
        return this.tickHeight;
    }

    @Override
    public void setTickHeight(double height) {
        this.tickHeight = height;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public double getMinorTickHeight() {
        return this.minorHeight;
    }

    @Override
    public void setMinorTickHeight(double height) {
        this.minorHeight = height;
    }

    @Override
    public float getTickLineWidth() {
        return this.tickLineWidth;
    }

    @Override
    public void setTickLineWidth(float width) {
        this.tickLineWidth = width;
        AxisImpl.redraw(this);
    }

    @Override
    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    @Override
    public void setLabelVisible(boolean visible) {
        this.labelVisible = visible;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public AxisOrientation getLabelOrientation() {
        return this.labelOrientation;
    }

    @Override
    public void setLabelOrientation(AxisOrientation orientation) {
        this.labelOrientation = orientation;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    private boolean isLabelSameOrientation() {
        return this.getOrientation() == this.getLabelOrientation();
    }

    @Override
    public AxisLabelSide getLabelSide() {
        return this.labelSide;
    }

    @Override
    public void setLabelSide(AxisLabelSide side) {
        this.labelSide = side;
        this.invalidateThickness();
        AxisImpl.redraw(this);
    }

    @Override
    public Color getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabelColor(Color color) {
        this.labelColor = color;
        AxisImpl.redraw(this);
    }

    private Font getActualLabelFont() {
        if (this.actualLabelFont != null) {
            return this.actualLabelFont;
        }
        return this.getEffectiveFont();
    }

    @Override
    public void setActualFont(Font font) {
        if (!font.equals(this.actualLabelFont)) {
            this.actualLabelFont = font;
            AxisImpl.redraw(this);
        }
    }

    @Override
    public AxisTitleEx getTitle() {
        return this.title;
    }

    @Override
    public double getThickness() {
        return this.asc + this.desc;
    }

    @Override
    public double getAsc() {
        return this.asc;
    }

    @Override
    public double getDesc() {
        return this.desc;
    }

    @Override
    public void invalidateThickness() {
        this.thicknessCalculationNeeded = true;
    }

    @Override
    public void calcThickness() {
        if (!this.thicknessCalculationNeeded) {
            return;
        }
        this.thicknessCalculationNeeded = false;
        this.asc = 0.0;
        this.desc = 0.0;
        this.labelOffset = 0.0;
        this.labelVAlign = null;
        this.labelHAlign = null;
        this.titleOffset = 0.0;
        this.titleVAlign = null;
        if (this.isTickVisible()) {
            if (this.isTickBothSide() || this.isTickAscSide()) {
                this.asc += this.getTickHeight();
            }
            if (this.isTickBothSide() || !this.isTickAscSide()) {
                this.desc += this.getTickHeight();
            }
        }
        if (this.isLabelVisible()) {
            double labelHeight = this.getLabelHeight();
            if (this.isLabelAscSide()) {
                this.labelOffset = this.asc + labelHeight * 0.25;
                this.asc = this.isLabelSameOrientation() ? this.labelOffset + labelHeight : this.labelOffset + this.getLabelsMaxPaperWidth();
            } else {
                this.labelOffset = -this.desc - labelHeight * 0.25;
                this.desc = this.isLabelSameOrientation() ? -this.labelOffset + labelHeight : -this.labelOffset + this.getLabelsMaxPaperWidth();
            }
            if (this.isLabelSameOrientation()) {
                this.labelRotation = 0.0;
                this.labelHAlign = HAlign.CENTER;
                this.labelVAlign = this.isLabelAscSide() ? VAlign.BOTTOM : VAlign.TOP;
            } else {
                this.labelRotation = this.getOrientation() == AxisOrientation.HORIZONTAL ? 1.5707963267948966 : -1.5707963267948966;
                this.labelVAlign = VAlign.MIDDLE;
                boolean axisPositiveSide = this.getPosition() == AxisPosition.POSITIVE_SIDE;
                boolean outwardSide = this.getLabelSide() == AxisLabelSide.OUTWARD;
                this.labelHAlign = axisPositiveSide == outwardSide ? HAlign.LEFT : HAlign.RIGHT;
            }
        }
        if (this.getTitle().isVisible() && this.getTitle().getTextModel() != null) {
            double titleHeight;
            if (this.isTitleAscSide()) {
                this.titleVAlign = VAlign.BOTTOM;
                this.getTitle().setVAlign(this.titleVAlign);
                titleHeight = this.getTitle().getSize().getHeight();
                this.titleOffset = this.asc + titleHeight * 0.25;
                this.asc = this.titleOffset + titleHeight;
            } else {
                this.titleVAlign = VAlign.TOP;
                this.getTitle().setVAlign(this.titleVAlign);
                titleHeight = this.getTitle().getSize().getHeight();
                this.titleOffset = -this.desc - titleHeight * 0.25;
                this.desc = -this.titleOffset + titleHeight;
            }
        }
    }

    private boolean isTitleAscSide() {
        boolean axisHorizontal = this.getOrientation() == AxisOrientation.HORIZONTAL;
        boolean axisPositiveSide = this.getPosition() == AxisPosition.POSITIVE_SIDE;
        return axisHorizontal == axisPositiveSide;
    }

    private boolean isTickBothSide() {
        return this.getTickSide() == AxisTickSide.BOTH;
    }

    private boolean isTickAscSide() {
        boolean axisHorizontal = this.getOrientation() == AxisOrientation.HORIZONTAL;
        boolean axisPositiveSide = this.getPosition() == AxisPosition.POSITIVE_SIDE;
        boolean outwardSide = this.getTickSide() == AxisTickSide.OUTWARD;
        return axisHorizontal == axisPositiveSide == outwardSide;
    }

    private boolean isLabelAscSide() {
        boolean axisHorizontal = this.getOrientation() == AxisOrientation.HORIZONTAL;
        boolean axisPositiveSide = this.getPosition() == AxisPosition.POSITIVE_SIDE;
        boolean outwardSide = this.getLabelSide() == AxisLabelSide.OUTWARD;
        return axisHorizontal == axisPositiveSide == outwardSide;
    }

    private double getLabelHeight() {
        FontRenderContext frc = new FontRenderContext(null, false, true);
        LineMetrics lm = this.getEffectiveFont().getLineMetrics("Can be any string", frc);
        return lm.getAscent() + lm.getDescent();
    }

    private double getLabelsMaxPaperWidth() {
        Dimension2D[] labelsSize = AxisImpl.getLabelsPaperSize(this.getTickManager().getLabelModels(), this.getEffectiveFont());
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (int i = 0; i < labelsSize.length; ++i) {
            if (maxWidth < labelsSize[i].getWidth()) {
                maxWidth = labelsSize[i].getWidth();
            }
            if (!(maxHeight < labelsSize[i].getHeight())) continue;
            maxHeight = labelsSize[i].getHeight();
        }
        return maxWidth;
    }

    public static Dimension2D[] getLabelsPaperSize(MathElement[] labels, Font labelFont) {
        Dimension2D[] ss = new Dimension2D[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            MathLabel labelDrawer = new MathLabel(labels[i], labelFont, VAlign.MIDDLE, HAlign.CENTER);
            Rectangle2D rect = labelDrawer.getBounds();
            ss[i] = new DoubleDimension2D(rect.getWidth(), rect.getHeight());
        }
        return ss;
    }

    @Override
    public ComponentEx copyStructure(Map<ElementEx, ElementEx> orig2copyMap) {
        AxisTickManagerEx atmCopy;
        AxisImpl result = new AxisImpl((AxisTitleEx)this.title.copyStructure(orig2copyMap));
        result.title.setParent(result);
        if (orig2copyMap != null) {
            orig2copyMap.put(this, result);
        }
        if ((atmCopy = (AxisTickManagerEx)orig2copyMap.get(this.tickManager)) == null) {
            atmCopy = (AxisTickManagerEx)this.tickManager.copyStructure(orig2copyMap);
        }
        result.tickManager = atmCopy;
        atmCopy.addAxis(result);
        return result;
    }

    @Override
    public void copyFrom(ElementEx src) {
        super.copyFrom(src);
        AxisImpl axis = (AxisImpl)src;
        this.locX = axis.locX;
        this.locY = axis.locY;
        this.orientation = axis.orientation;
        this.length = axis.length;
        this.position = axis.position;
        this.axisLineWidth = axis.axisLineWidth;
        this.showGridLines = axis.showGridLines;
        this.showMinorGridLines = axis.showMinorGridLines;
        this.tickVisible = axis.tickVisible;
        this.tickSide = axis.tickSide;
        this.tickHeight = axis.tickHeight;
        this.minorHeight = axis.minorHeight;
        this.tickLineWidth = axis.tickLineWidth;
        this.labelVisible = axis.labelVisible;
        this.labelOrientation = axis.labelOrientation;
        this.labelSide = axis.labelSide;
        this.labelColor = axis.labelColor;
        this.asc = axis.asc;
        this.desc = axis.desc;
        this.labelOffset = axis.labelOffset;
        this.labelRotation = axis.labelRotation;
        this.labelHAlign = axis.labelHAlign;
        this.labelVAlign = axis.labelVAlign;
        this.titleOffset = axis.titleOffset;
        this.titleVAlign = axis.titleVAlign;
        this.actualLabelFont = axis.actualLabelFont;
    }

    @Override
    public void draw(Graphics2D graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.transform(this.getPaperTransform().getTransform());
        g.setColor(this.getEffectiveColor());
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(this.axisLineWidth, 0, 0));
        this.drawAxisLine(g);
        g.setStroke(new BasicStroke(this.tickLineWidth, 0, 0));
        this.drawTicks(g);
        if (this.isLabelVisible()) {
            this.drawLabels(g, this.labelVAlign, this.labelHAlign);
        }
        if (this.getTitle().isVisible() && this.getTitle().getTextModel() != null) {
            this.drawTitle(graphics);
        }
        g.dispose();
    }

    private void drawAxisLine(Graphics2D g2) {
        Line2D.Double s = new Line2D.Double(0.0, 0.0, this.getLength(), 0.0);
        g2.draw(s);
    }

    private void drawTicks(Graphics2D g) {
        double xp;
        int i;
        AxisEx[] orthoAxes;
        Dimension2D pcontentSize;
        Color c;
        BasicStroke gridLineStroke;
        Color oldColor;
        Stroke oldStroke;
        Object tvs = this.getTickManager().getTickValues();
        Object mvs = this.getTickManager().getMinorTickValues();
        int tvslen = Array.getLength(tvs);
        int mvslen = Array.getLength(mvs);
        if (this.showGridLines && tvslen > 0) {
            oldStroke = g.getStroke();
            oldColor = g.getColor();
            gridLineStroke = new BasicStroke(((BasicStroke)oldStroke).getLineWidth() / 2.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
            g.setStroke(gridLineStroke);
            c = this.getEffectiveColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() / 2));
            pcontentSize = this.getParent().getContentSize();
            orthoAxes = this.getOrthoAxes();
            for (i = 0; i < tvslen; ++i) {
                xp = this.transTickToPaper(Array.getDouble(tvs, i));
                this.drawGridLine(g, xp, pcontentSize, orthoAxes);
            }
            g.setStroke(oldStroke);
            g.setColor(oldColor);
        }
        if (this.showMinorGridLines && mvslen > 0) {
            oldStroke = g.getStroke();
            oldColor = g.getColor();
            gridLineStroke = new BasicStroke(((BasicStroke)oldStroke).getLineWidth() / 4.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
            g.setStroke(gridLineStroke);
            c = this.getEffectiveColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha() / 4));
            pcontentSize = this.getParent().getContentSize();
            orthoAxes = this.getOrthoAxes();
            for (i = 0; i < mvslen; ++i) {
                xp = this.transTickToPaper(Array.getDouble(mvs, i));
                this.drawGridLine(g, xp, pcontentSize, orthoAxes);
            }
            g.setStroke(oldStroke);
            g.setColor(oldColor);
        }
        if (this.isTickVisible()) {
            int i2;
            for (i2 = 0; i2 < tvslen; ++i2) {
                double xp2 = this.transTickToPaper(Array.getDouble(tvs, i2));
                this.drawTic(g, xp2, this.getTickHeight());
            }
            for (i2 = 0; i2 < mvslen; ++i2) {
                double xp3 = this.transTickToPaper(Array.getDouble(mvs, i2));
                this.drawTic(g, xp3, this.getMinorTickHeight());
            }
        }
    }

    private void drawLabels(Graphics2D g, VAlign vertalign, HAlign horzalign) {
        Object tvs = this.getTickManager().getTickValues();
        MathElement[] labels = this.getTickManager().getLabelModels();
        Color color = this.getLabelColor();
        g.setColor(color);
        AffineTransform oldTransform = g.getTransform();
        for (int i = 0; i < labels.length; ++i) {
            double x = Array.getDouble(tvs, i * this.getTickManager().getLabelInterval());
            double xt = this.transTickToPaper(x);
            MathLabel label = new MathLabel(labels[i], this.getActualLabelFont(), vertalign, horzalign);
            g.translate(xt, this.labelOffset);
            if (this.labelRotation != 0.0) {
                g.rotate(this.labelRotation);
            }
            g.scale(1.0, -1.0);
            label.draw(g);
            g.setTransform(oldTransform);
        }
    }

    private void drawTitle(Graphics2D g) {
        double x = this.getLength() * 0.5;
        this.getTitle().draw(g, x, this.titleOffset);
    }

    private void drawTic(Graphics2D g, double xp, double ticHeight) {
        double yp1;
        double yp0;
        if (this.isTickBothSide()) {
            yp0 = ticHeight;
            yp1 = -ticHeight;
        } else if (this.isTickAscSide()) {
            yp0 = ticHeight;
            yp1 = 0.0;
        } else {
            yp0 = 0.0;
            yp1 = -ticHeight;
        }
        Line2D.Double line = new Line2D.Double(xp, yp0, xp, yp1);
        g.draw(line);
    }

    private void drawGridLine(Graphics2D g, double xp, Dimension2D contentSize, AxisEx[] orthoAxes) {
        if (this.getOrientation() == AxisOrientation.HORIZONTAL) {
            Line2D.Double line;
            for (AxisEx axis : orthoAxes) {
                if (!(Math.abs(axis.getLocation().getX() - xp) < 1.0)) continue;
                return;
            }
            if (this.position == AxisPosition.NEGATIVE_SIDE) {
                line = new Line2D.Double(xp, 0.0, xp, contentSize.getHeight());
                g.draw(line);
            } else {
                line = new Line2D.Double(xp, -contentSize.getHeight(), xp, 0.0);
                g.draw(line);
            }
        } else {
            Line2D.Double line;
            for (AxisEx axis : orthoAxes) {
                if (!(Math.abs(axis.getLocation().getY() - xp) < 1.0)) continue;
                return;
            }
            if (this.position == AxisPosition.NEGATIVE_SIDE) {
                line = new Line2D.Double(xp, -contentSize.getWidth(), xp, 0.0);
                g.draw(line);
            } else {
                line = new Line2D.Double(xp, 0.0, xp, contentSize.getWidth());
                g.draw(line);
            }
        }
    }

    private AxisEx[] getOrthoAxes() {
        ArrayList<AxisEx> axes = new ArrayList<AxisEx>();
        if (this.getOrientation() == AxisOrientation.HORIZONTAL) {
            for (AxisEx a : this.getParent().getYAxes()) {
                axes.add(a);
            }
        } else {
            for (AxisEx a : this.getParent().getXAxes()) {
                axes.add(a);
            }
        }
        return axes.toArray(new AxisEx[axes.size()]);
    }

    private double transTickToPaper(double tickValue) {
        double uv = this.tickManager.getTickTransform() != null ? this.tickManager.getTickTransform().transformTick2User(tickValue) : tickValue;
        return this.tickManager.getAxisTransform().getNormalTransform().convToNR(uv) * this.length;
    }
}

