/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.element.impl;

import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import org.jplot2d.element.Layer;
import org.jplot2d.element.impl.AnnotationEx;
import org.jplot2d.element.impl.ComponentImpl;
import org.jplot2d.element.impl.InvokeStep;
import org.jplot2d.element.impl.LayerEx;

public abstract class AnnotationImpl
extends ComponentImpl
implements AnnotationEx {
    protected static final BasicStroke DEFAULT_STROKE = new BasicStroke();
    protected static final BasicStroke ZERO_WIDTH_STROKE = new BasicStroke(0.0f);

    public AnnotationImpl() {
        this.setSelectable(true);
        this.setMovable(true);
    }

    @Override
    public InvokeStep getInvokeStepFormParent() {
        Method method;
        if (this.parent == null) {
            return null;
        }
        try {
            method = Layer.class.getMethod("getAnnotation", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        return new InvokeStep(method, this.getParent().indexOf(this));
    }

    @Override
    public LayerEx getParent() {
        return (LayerEx)super.getParent();
    }

    @Override
    public void thisEffectiveColorChanged() {
        AnnotationImpl.redraw(this);
    }

    @Override
    public void thisEffectiveFontChanged() {
        AnnotationImpl.redraw(this);
    }

    @Override
    public final void setLocation(Point2D p) {
        this.setLocation(p.getX(), p.getY());
    }

    protected double getXWtoP(double v) {
        LayerEx layer = this.getParent();
        return layer.getXAxisTransform().getNormalTransform().convToNR(v) * layer.getSize().getWidth();
    }

    protected double getYWtoP(double v) {
        LayerEx layer = this.getParent();
        return layer.getYAxisTransform().getNormalTransform().convToNR(v) * layer.getSize().getHeight();
    }

    protected double getXPtoW(double v) {
        LayerEx layer = this.getParent();
        return layer.getXAxisTransform().getNormalTransform().convFromNR(v / layer.getSize().getWidth());
    }

    protected double getYPtoW(double v) {
        LayerEx layer = this.getParent();
        return layer.getYAxisTransform().getNormalTransform().convFromNR(v / layer.getSize().getHeight());
    }
}

