/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import org.jplot2d.data.ArrayPair;
import org.jplot2d.data.GraphData;
import org.jplot2d.util.Range;

public final class XYGraphData
implements GraphData {
    private static final int DEFAULT_CAPACITY = 4;
    private final ArrayPair _xy;
    private final ArrayPair _errorX;
    private final ArrayPair _errorY;
    private int[] _rsIdxes;
    private int[] _reIdxes;
    private int _nraLastIdx;
    private int _nanCount;
    private boolean xPositiveInfinity;
    private boolean xNegativeInfinity;
    private boolean yPositiveInfinity;
    private boolean yNegativeInfinity;
    private double _xmin = Double.NaN;
    private double _xmax = Double.NaN;
    private double _ymin = Double.NaN;
    private double _ymax = Double.NaN;
    private final Range _xboundary;
    private final Range _yboundary;
    private boolean hasPointOutsideXBounds;
    private boolean hasPointOutsideYBounds;

    public XYGraphData(ArrayPair xy) {
        this(xy, null, null);
    }

    public XYGraphData(ArrayPair xy, ArrayPair errorX, ArrayPair errorY) {
        this(xy, errorX, errorY, null, null);
    }

    private XYGraphData(ArrayPair xy, ArrayPair errorX, ArrayPair errorY, Range xboundary, Range yboundary) {
        this._xy = xy;
        this._errorX = errorX;
        this._errorY = errorY;
        this._xboundary = xboundary;
        this._yboundary = yboundary;
        this.extractDataFeature();
    }

    @Override
    public XYGraphData applyBoundary(Range xboundary, Range yboundary) {
        return new XYGraphData(this._xy, this._errorX, this._errorY, xboundary, yboundary);
    }

    private final void extractDataFeature() {
        this._rsIdxes = new int[4];
        this._reIdxes = new int[4];
        this._nraLastIdx = -1;
        for (int i = 0; i < this._xy.size(); ++i) {
            double x = this.getX(i);
            double y = this.getY(i);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                this.addNaNIdx(i);
                continue;
            }
            if (x == Double.POSITIVE_INFINITY) {
                this.xPositiveInfinity = true;
                continue;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                this.xNegativeInfinity = true;
                continue;
            }
            if (y == Double.POSITIVE_INFINITY) {
                this.yPositiveInfinity = true;
                continue;
            }
            if (y == Double.NEGATIVE_INFINITY) {
                this.yNegativeInfinity = true;
                continue;
            }
            double xlow = x;
            double xhigh = x;
            double ylow = y;
            double yhigh = y;
            if (this._errorX != null && i < this._errorX.size()) {
                double xel = this.getXErrorLow(i);
                double xeh = this.getXErrorHigh(i);
                if (!Double.isNaN(xel) && !Double.isInfinite(xel)) {
                    double xelow = x - xel;
                    if (xlow > xelow) {
                        xlow = xelow;
                    }
                    if (xhigh < xelow) {
                        xhigh = xelow;
                    }
                }
                if (!Double.isNaN(xeh) && !Double.isInfinite(xeh)) {
                    double xehigh = x + xeh;
                    if (xlow > xehigh) {
                        xlow = xehigh;
                    }
                    if (xhigh < xehigh) {
                        xhigh = xehigh;
                    }
                }
            }
            if (this._errorY != null && i < this._errorY.size()) {
                double yel = this.getYErrorLow(i);
                double yeh = this.getYErrorHigh(i);
                if (!Double.isNaN(yel) && !Double.isInfinite(yel)) {
                    double yelow = y - yel;
                    if (ylow > yelow) {
                        ylow = yelow;
                    }
                    if (yhigh < yelow) {
                        yhigh = yelow;
                    }
                }
                if (!Double.isNaN(yeh) && !Double.isInfinite(yeh)) {
                    double yehigh = y + yeh;
                    if (ylow > yehigh) {
                        ylow = yehigh;
                    }
                    if (yhigh < yehigh) {
                        yhigh = yehigh;
                    }
                }
            }
            if (this.inXBoundary(x) && this.inYBoundary(y)) {
                if (this.inXBoundary(xlow)) {
                    if (!(this._xmin <= xlow)) {
                        this._xmin = xlow;
                    }
                } else if (!(this._xmin <= x)) {
                    this._xmin = x;
                }
                if (this.inXBoundary(xhigh)) {
                    if (!(this._xmax >= xhigh)) {
                        this._xmax = xhigh;
                    }
                } else if (!(this._xmax >= x)) {
                    this._xmax = x;
                }
                if (this.inYBoundary(ylow)) {
                    if (!(this._ymin <= ylow)) {
                        this._ymin = ylow;
                    }
                } else if (!(this._ymin <= y)) {
                    this._ymin = y;
                }
                if (this.inYBoundary(yhigh)) {
                    if (this._ymax >= yhigh) continue;
                    this._ymax = yhigh;
                    continue;
                }
                if (this._ymax >= y) continue;
                this._ymax = y;
                continue;
            }
            if (!this.inXBoundary(x)) {
                this.hasPointOutsideXBounds = true;
            }
            if (this.inYBoundary(y)) continue;
            this.hasPointOutsideYBounds = true;
        }
    }

    private boolean inXBoundary(double x) {
        return this._xboundary == null ? true : this._xboundary.contains(x);
    }

    private boolean inYBoundary(double y) {
        return this._yboundary == null ? true : this._yboundary.contains(y);
    }

    private void addNaNIdx(int idx) {
        ++this._nanCount;
        if (this._nraLastIdx == -1) {
            this._nraLastIdx = 0;
            this._rsIdxes[this._nraLastIdx] = this._reIdxes[this._nraLastIdx] = idx;
        } else if (idx == this._reIdxes[this._nraLastIdx] + 1) {
            this._reIdxes[this._nraLastIdx] = idx;
        } else {
            ++this._nraLastIdx;
            if (this._nraLastIdx == this._rsIdxes.length) {
                int[] rstmp = new int[this._rsIdxes.length * 2];
                System.arraycopy(this._rsIdxes, 0, rstmp, 0, this._rsIdxes.length);
                this._rsIdxes = rstmp;
                int[] retmp = new int[this._reIdxes.length * 2];
                System.arraycopy(this._reIdxes, 0, retmp, 0, this._reIdxes.length);
                this._reIdxes = retmp;
            }
            this._rsIdxes[this._nraLastIdx] = this._reIdxes[this._nraLastIdx] = idx;
        }
    }

    public XYGraphData addPoints(ArrayPair xy) {
        if (xy != null) {
            XYGraphData nld = new XYGraphData(this._xy.append(xy), this._errorX, this._errorY);
            return nld;
        }
        return this;
    }

    public ArrayPair getXy() {
        return this._xy;
    }

    public double getX(int idx) {
        return this._xy.getPDouble(idx);
    }

    public double getY(int idx) {
        return this._xy.getQDouble(idx);
    }

    @Override
    public Range getXRange() {
        return new Range.Double(this._xmin, this._xmax);
    }

    @Override
    public Range getYRange() {
        return new Range.Double(this._ymin, this._ymax);
    }

    @Override
    public boolean hasPointOutsideXBounds() {
        return this.hasPointOutsideXBounds;
    }

    @Override
    public boolean hasPointOutsideYBounds() {
        return this.hasPointOutsideYBounds;
    }

    public boolean isInfiniteX() {
        return this.xPositiveInfinity || this.xNegativeInfinity;
    }

    public boolean isInfiniteY() {
        return this.yPositiveInfinity || this.yNegativeInfinity;
    }

    public int[][] getNaNIndexes() {
        int[][] result = new int[2][this._nraLastIdx + 1];
        System.arraycopy(this._rsIdxes, 0, result[0], 0, this._nraLastIdx + 1);
        System.arraycopy(this._reIdxes, 0, result[1], 0, this._nraLastIdx + 1);
        return result;
    }

    public int getNaNIndexesCount() {
        return this._nanCount;
    }

    public int size() {
        return this._xy.size();
    }

    public ArrayPair getXError() {
        return this._errorX;
    }

    public ArrayPair getYError() {
        return this._errorY;
    }

    public double getXErrorLow(int idx) {
        return this._errorX.getPDouble(idx);
    }

    public double getXErrorHigh(int idx) {
        return this._errorX.getQDouble(idx);
    }

    public double getYErrorLow(int idx) {
        return this._errorY.getPDouble(idx);
    }

    public double getYErrorHigh(int idx) {
        return this._errorY.getQDouble(idx);
    }
}

