/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.data;

import java.nio.FloatBuffer;
import org.jplot2d.data.ImageDataBuffer;
import org.jplot2d.data.ImageMaskBuffer;

public abstract class FloatDataBuffer
extends ImageDataBuffer {
    public FloatDataBuffer(ImageMaskBuffer mask) {
        super(mask);
    }

    @Override
    public byte getByte(int x, int y) {
        return (byte)this.get(x, y);
    }

    @Override
    public short getShort(int x, int y) {
        return (short)this.get(x, y);
    }

    @Override
    public int getInt(int x, int y) {
        return (int)this.get(x, y);
    }

    @Override
    public float getFloat(int x, int y) {
        return this.get(x, y);
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }

    public abstract float get(int var1, int var2);

    @Override
    public double countValid(int w, int h) {
        int count = 0;
        if (!this.hasMasks()) {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    float v = this.get(i, j);
                    if (v != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                    ++count;
                }
            }
        } else {
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    float v;
                    if (this.isMasked(i, j) || (v = this.get(i, j)) != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public double[] calcMinMax(int w, int h) {
        float v;
        int i;
        int j;
        float min = Float.NaN;
        float max = Float.NaN;
        int m = -1;
        int n = -1;
        for (j = 0; j < h; ++j) {
            for (i = 0; i < w; ++i) {
                v = this.get(i, j);
                if (this.isMasked(i, j) || v != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                min = v;
                max = v;
                m = i;
                n = j;
                break;
            }
            if (n != -1) break;
        }
        if (n == -1) {
            return null;
        }
        ++m;
        for (j = n; j < h; ++j) {
            for (i = m; i < w; ++i) {
                v = this.get(i, j);
                if (this.isMasked(i, j) || v != v || v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) continue;
                if (min > v) {
                    min = v;
                }
                if (!(max < v)) continue;
                max = v;
            }
            m = 0;
        }
        return new double[]{min, max};
    }

    public static class NioBuffer
    extends FloatDataBuffer {
        private final FloatBuffer data;
        private final int offset;

        public NioBuffer(FloatBuffer data) {
            this(data, 0, null);
        }

        public NioBuffer(FloatBuffer data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public NioBuffer(FloatBuffer data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public float get(int x, int y) {
            return this.data.get(this.offset + x + y);
        }
    }

    public static class Array2D
    extends FloatDataBuffer {
        private final float[][] data;
        private final int xoffset;
        private final int yoffset;

        public Array2D(float[][] data) {
            this(data, 0, 0, null);
        }

        public Array2D(float[][] data, ImageMaskBuffer mask) {
            this(data, 0, 0, mask);
        }

        public Array2D(float[][] data, int xoffset, int yoffset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }

        @Override
        public float get(int x, int y) {
            return this.data[this.yoffset + y][this.xoffset + x];
        }
    }

    public static class Array
    extends FloatDataBuffer {
        private final float[] data;
        private final int offset;

        public Array(float[] data) {
            this(data, 0, null);
        }

        public Array(float[] data, ImageMaskBuffer mask) {
            this(data, 0, mask);
        }

        public Array(float[] data, int offset, ImageMaskBuffer mask) {
            super(mask);
            this.data = data;
            this.offset = offset;
        }

        @Override
        public float get(int x, int y) {
            return this.data[this.offset + x + y];
        }
    }
}

