/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtype;

import org.jplot2d.axtick.LinearTickAlgorithm;
import org.jplot2d.axtick.LogTickAlgorithm;
import org.jplot2d.axtick.ReciprocalTickAlgorithm;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtype.AxisType;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.ReciprocalAxisTickTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public class NumberAxisType
extends AxisType {
    private static final Range LINEAR_BOUNDARY = new Range.Double(-8.988465674311579E307, 8.988465674311579E307);
    private static final Range LINEAR_DEFAULT_RANGE = new Range.Double(-1.0, 1.0);
    private static final Range POSITIVE_BOUNDARY = new Range.Double(Double.MIN_VALUE, true, 8.988465674311579E307, true);
    private static final Range LOG_DEFAULT_RANGE = new Range.Double(0.1, 10.0);

    public static NumberAxisType getInstance() {
        return new NumberAxisType();
    }

    private NumberAxisType() {
        super("NUMBER");
    }

    @Override
    public boolean canSupport(TransformType txfType) {
        if (txfType == TransformType.LINEAR) {
            return true;
        }
        return txfType == TransformType.LOGARITHMIC;
    }

    @Override
    public Range getBoundary(TransformType txfType) {
        if (txfType == TransformType.LINEAR) {
            return LINEAR_BOUNDARY;
        }
        if (txfType == TransformType.LOGARITHMIC) {
            return POSITIVE_BOUNDARY;
        }
        return null;
    }

    @Override
    public Range getDefaultWorldRange(TransformType txfType) {
        if (txfType == TransformType.LINEAR) {
            return LINEAR_DEFAULT_RANGE;
        }
        if (txfType == TransformType.LOGARITHMIC) {
            return LOG_DEFAULT_RANGE;
        }
        return null;
    }

    @Override
    public TransformType getDefaultTransformType() {
        return TransformType.LINEAR;
    }

    @Override
    public TickAlgorithm getTickAlgorithm(TransformType txfType, AxisTickTransform tickTransform) {
        if (tickTransform == null) {
            if (txfType == TransformType.LINEAR) {
                return LinearTickAlgorithm.getInstance();
            }
            if (txfType == TransformType.LOGARITHMIC) {
                return LogTickAlgorithm.getInstance();
            }
        } else if (tickTransform instanceof ReciprocalAxisTickTransform) {
            if (txfType == TransformType.LINEAR) {
                return ReciprocalTickAlgorithm.getInstance();
            }
            if (txfType == TransformType.LOGARITHMIC) {
                return LogTickAlgorithm.getInstance();
            }
        }
        return null;
    }
}

