/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtype;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jplot2d.axtick.TickAlgorithm;
import org.jplot2d.axtype.DateAxisType;
import org.jplot2d.axtype.DeclinationAxisType;
import org.jplot2d.axtype.NumberAxisType;
import org.jplot2d.axtype.RightAscensionAxisType;
import org.jplot2d.axtype.TAIMicrosAxisType;
import org.jplot2d.transform.AxisTickTransform;
import org.jplot2d.transform.TransformType;
import org.jplot2d.util.Range;

public abstract class AxisType {
    private static final Map<String, AxisType> axisTypeMap = Collections.synchronizedMap(new LinkedHashMap());
    public static final AxisType NUMBER = NumberAxisType.getInstance();
    public static final AxisType DATE = DateAxisType.getDefault();
    public static final AxisType DATE_UTC_US = DateAxisType.getUTC();
    public static final AxisType TAI_MICROS_UTC_US = TAIMicrosAxisType.getUTC();
    public static final AxisType RIGHT_ASCENSION = RightAscensionAxisType.getInstance();
    public static final AxisType DECLINATION = DeclinationAxisType.getInstance();
    private final String name;

    public AxisType(String name) {
        this.name = name;
        axisTypeMap.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean canSupport(TransformType var1);

    public abstract TransformType getDefaultTransformType();

    public abstract Range getBoundary(TransformType var1);

    public abstract Range getDefaultWorldRange(TransformType var1);

    public abstract TickAlgorithm getTickAlgorithm(TransformType var1, AxisTickTransform var2);

    public Range getCircularRange() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static AxisType valueOf(String name) {
        return axisTypeMap.get(name);
    }

    public static AxisType[] values() {
        return axisTypeMap.values().toArray(new AxisType[0]);
    }
}

