/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class TAIMicrosCalendar
implements Comparable<TAIMicrosCalendar>,
Cloneable {
    public static long TAI_EPOCH_OFFSET = -378691200000L;
    public static int MICROSECOND = 17;
    final Calendar calendar;
    int microsecond;

    private TAIMicrosCalendar(Calendar calendar, int microsecond) {
        this.calendar = calendar;
        this.microsecond = microsecond;
    }

    public TAIMicrosCalendar(TimeZone zone, Locale locale) {
        this.calendar = Calendar.getInstance(zone, locale);
    }

    public long getTimeInMicros() {
        return (this.calendar.getTimeInMillis() - TAI_EPOCH_OFFSET) * 1000L + (long)this.microsecond;
    }

    public void setTimeInMicros(long micros) {
        this.microsecond = (int)(micros % 1000L);
        long millis = micros / 1000L + TAI_EPOCH_OFFSET;
        this.calendar.setTimeInMillis(millis);
    }

    public Object clone() {
        return new TAIMicrosCalendar(this.calendar, this.microsecond);
    }

    public int get(int field) {
        if (field == MICROSECOND) {
            return this.microsecond;
        }
        return this.calendar.get(field);
    }

    public void set(int field, int value) {
        if (field == MICROSECOND) {
            this.microsecond = value;
        } else {
            this.calendar.set(field, value);
        }
    }

    public final void set(int year, int month, int date, int hourOfDay, int minute, int second) {
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, date);
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
    }

    public int getMinimum(int field) {
        if (field == MICROSECOND) {
            return 0;
        }
        return this.calendar.getMinimum(field);
    }

    public void add(int field, int amount) {
        if (field == MICROSECOND) {
            this.microsecond += amount;
            if (this.microsecond < 0 || this.microsecond >= 1000) {
                this.calendar.add(14, this.microsecond / 1000);
                this.microsecond %= 1000;
                if (this.microsecond < 0) {
                    this.microsecond += 1000;
                    this.calendar.add(14, -1);
                }
            }
        } else {
            this.calendar.add(field, amount);
        }
    }

    public boolean before(TAIMicrosCalendar when) {
        return this.compareTo(when) < 0;
    }

    public boolean after(TAIMicrosCalendar when) {
        return this.compareTo(when) > 0;
    }

    @Override
    public int compareTo(TAIMicrosCalendar anotherTAI) {
        int compare = this.calendar.compareTo(anotherTAI.calendar);
        if (compare == 0) {
            return this.microsecond - anotherTAI.microsecond;
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TAIMicrosCalendar) {
            TAIMicrosCalendar another = (TAIMicrosCalendar)obj;
            return this.microsecond == another.microsecond && this.calendar.equals(another.calendar);
        }
        return false;
    }

    public String toString() {
        return "TAI MICRO=" + this.microsecond + "," + this.calendar.toString();
    }
}

