/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.axtick;

public final class DateInterval {
    private final Unit unit;
    private final int v;

    public DateInterval(Unit unit, int value) {
        this.unit = unit;
        this.v = value;
    }

    public static DateInterval createWithMillis(long interval) {
        int v;
        Unit unit;
        if (interval < Unit.SECOND.time) {
            unit = Unit.MILLISECOND;
            v = (int)interval;
        } else if (interval < Unit.MINUTE.time) {
            unit = Unit.SECOND;
            v = (int)(interval / Unit.SECOND.time);
        } else if (interval < Unit.HOUR.time) {
            unit = Unit.MINUTE;
            v = (int)(interval / Unit.MINUTE.time);
        } else if (interval < Unit.DAY.time) {
            unit = Unit.HOUR;
            v = (int)(interval / Unit.HOUR.time);
        } else if (interval < Unit.MONTH.time) {
            unit = Unit.DAY;
            v = (int)(interval / Unit.DAY.time);
        } else if (interval < Unit.YEAR.time) {
            unit = Unit.MONTH;
            v = (int)(interval / Unit.MONTH.time);
        } else {
            unit = Unit.YEAR;
            v = (int)(interval / Unit.YEAR.time);
        }
        return new DateInterval(unit, v);
    }

    public static DateInterval createWithMicros(long interval) {
        if (interval < 1000L) {
            return new DateInterval(Unit.MICROSECOND, (int)interval);
        }
        return DateInterval.createWithMillis(interval / 1000L);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getValue() {
        return this.v;
    }

    public long getTimeInMillis() {
        return (long)this.v * this.unit.time;
    }

    public long getTimeInMicros() {
        if (this.unit == Unit.MICROSECOND) {
            return this.v;
        }
        return (long)this.v * this.unit.time * 1000L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval ien = (DateInterval)obj;
        return this.getValue() == ien.getValue() && this.getUnit() == ien.getUnit();
    }

    public int hashCode() {
        return this.getValue() ^ this.getUnit().ordinal() << 28;
    }

    public String toString() {
        return String.valueOf(this.v) + (Object)((Object)this.unit);
    }

    public static enum Unit {
        MICROSECOND(0L),
        MILLISECOND(1L),
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L),
        WEEK(604800000L),
        MONTH(2592000000L),
        YEAR(31104000000L);

        public final long time;

        private Unit(long time) {
            this.time = time;
        }
    }
}

