/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

public class DiscretizedCircle {
    public static int[] imageOffsets(double radius, int imgWidth) {
        double PI2 = Math.PI * 2;
        double circumference = PI2 * radius;
        int num = (int)Math.ceil(circumference);
        num -= num % 4;
        double angleStep = PI2 / (double)num;
        int[] temp = new int[(int)Math.ceil(circumference)];
        int i = 0;
        int prev = 0;
        for (double ang = 0.0; ang < PI2; ang += angleStep) {
            int x = (int)Math.round(Math.cos(ang) * radius);
            int y = (int)Math.round(Math.sin(ang) * radius);
            int pixel = y * imgWidth + x;
            if (pixel != prev) {
                temp[i++] = pixel;
            }
            prev = pixel;
        }
        if (i == temp.length) {
            return temp;
        }
        int[] ret = new int[i];
        System.arraycopy(temp, 0, ret, 0, i);
        return ret;
    }

    public static int[][] imageOffsets2(double radius) {
        double PI2 = Math.PI * 2;
        double circumference = PI2 * radius;
        int num = (int)Math.ceil(circumference);
        num -= num % 4;
        double angleStep = PI2 / (double)num;
        int[][] temp = new int[num][2];
        for (int i = 0; i < num; ++i) {
            double ang = angleStep * (double)i;
            int x = (int)Math.round(Math.cos(ang) * radius);
            int y = (int)Math.round(Math.sin(ang) * radius);
            temp[i][0] = x;
            temp[i][1] = y;
        }
        return temp;
    }
}

