/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageGridPanel
extends JPanel {
    BufferedImage[] images;
    int numRows;
    int numCols;

    public ImageGridPanel(int numRows, int numCols) {
        this.images = new BufferedImage[numRows * numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public ImageGridPanel(int numRows, int numCols, BufferedImage ... images) {
        this.images = new BufferedImage[numRows * numCols];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = images[i];
        }
        this.numRows = numRows;
        this.numCols = numCols;
        this.autoSetPreferredSize();
    }

    public synchronized void autoSetPreferredSize() {
        int width = 0;
        int height = 0;
        for (int row = 0; row < this.numRows; ++row) {
            int h = 0;
            int w = 0;
            for (int col = 0; col < this.numCols; ++col) {
                BufferedImage img = this.images[row * this.numCols + col];
                if (img == null) continue;
                w += img.getWidth();
                h = Math.max(h, img.getHeight());
            }
            width = Math.max(w, width);
            height += h;
        }
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int y = 0;
        for (int row = 0; row < this.numRows; ++row) {
            int rowHeight = 0;
            int x = 0;
            for (int col = 0; col < this.numCols; ++col) {
                BufferedImage img = this.images[row * this.numCols + col];
                if (img == null) continue;
                g2.drawImage((Image)img, x, y, null);
                x += img.getWidth();
                rowHeight = Math.max(rowHeight, img.getHeight());
            }
            y += rowHeight;
        }
    }

    public synchronized void setImage(int row, int col, BufferedImage image) {
        this.images[row * this.numCols + col] = image;
    }

    public synchronized BufferedImage getImage(int row, int col) {
        return this.images[row * this.numCols + col];
    }

    public synchronized void setImages(BufferedImage ... images) {
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = images[i];
        }
        this.autoSetPreferredSize();
    }
}

