/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class FancyInterestPointRender {
    List<Point> points = new ArrayList<Point>();
    List<Line> lines = new ArrayList<Line>();
    List<Circle> circles = new ArrayList<Circle>();
    List<VString> strings = new ArrayList<VString>();

    public synchronized void draw(Graphics2D g2) {
        int w;
        for (Point p : this.points) {
            g2.setColor(p.color);
            w = p.radius * 2 + 1;
            g2.fillOval(p.x - p.radius, p.y - p.radius, w, w);
            int r = p.radius + 1;
            g2.setColor(Color.BLACK);
            g2.drawOval(p.x - r, p.y - r, w += 2, w);
        }
        for (Circle c : this.circles) {
            g2.setColor(c.color);
            w = c.radius * 2 + 1;
            g2.drawOval(c.x - c.radius, c.y - c.radius, w, w);
            g2.fillOval(c.x - 1, c.y - 1, 3, 3);
            if (Double.isNaN(c.direction)) continue;
            g2.setColor(Color.BLUE);
            int dx = (int)(Math.cos(c.direction) * (double)c.radius);
            int dy = (int)(Math.sin(c.direction) * (double)c.radius);
            g2.drawLine(c.x, c.y, c.x + dx, c.y + dy);
        }
        for (Line l : this.lines) {
            g2.setColor(l.color);
            g2.drawLine(l.x0, l.y0, l.x1, l.y1);
        }
    }

    public synchronized void reset() {
        this.points.clear();
        this.lines.clear();
        this.circles.clear();
        this.strings.clear();
    }

    public synchronized void addString(int x, int y, String value) {
        VString s = new VString();
        s.x = x;
        s.y = y;
        s.value = value;
    }

    public synchronized void addPoint(int x, int y) {
        Point p = new Point();
        p.x = x;
        p.y = y;
        this.points.add(p);
    }

    public synchronized void addPoint(int x, int y, int radius, Color color) {
        Point p = new Point();
        p.x = x;
        p.y = y;
        p.radius = radius;
        p.color = color;
        this.points.add(p);
    }

    public synchronized void addCircle(int x, int y, int radius) {
        Circle p = new Circle();
        p.x = x;
        p.y = y;
        p.radius = radius;
        this.circles.add(p);
    }

    public synchronized void addLine(int x0, int y0, int x1, int y1) {
        Line p = new Line();
        p.x0 = x0;
        p.y0 = y0;
        p.x1 = x1;
        p.y1 = y1;
        this.lines.add(p);
    }

    public synchronized void addCircle(int x, int y, int radius, Color color) {
        Circle p = new Circle();
        p.x = x;
        p.y = y;
        p.radius = radius;
        p.color = color;
        this.circles.add(p);
    }

    public synchronized void addCircle(int x, int y, int radius, Color color, double direction) {
        Circle p = new Circle();
        p.x = x;
        p.y = y;
        p.radius = radius;
        p.color = color;
        p.direction = direction;
        this.circles.add(p);
    }

    public static class Circle {
        int x;
        int y;
        int radius;
        double direction = Double.NaN;
        Color color = Color.RED;
    }

    public static class Point {
        int x;
        int y;
        int radius = 1;
        Color color = Color.RED;
    }

    public static class Line {
        int x0;
        int y0;
        int x1;
        int y1;
        Color color = Color.BLUE;
    }

    public static class VString {
        int x;
        int y;
        String value;
    }
}

