/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.VisualizeApp;
import boofcv.io.PathLabel;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageType;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class VideoProcessAppBase<I extends ImageBase>
extends SelectAlgorithmAndInputPanel
implements VisualizeApp,
MouseListener,
ChangeListener {
    protected SimpleImageSequence<I> sequence;
    volatile boolean requestStop = false;
    volatile boolean isRunning = false;
    protected volatile boolean isPaused = false;
    long framePeriod = 100L;
    protected JSpinner periodSpinner;
    protected ImageType<I> imageType;

    public VideoProcessAppBase(int numAlgFamilies, Class<I> imageClass) {
        super(numAlgFamilies);
        this.imageType = new ImageType(ImageType.Family.GRAY, ImageDataType.classToType(imageClass), 1);
        this.addToToolbar(this.createSelectDelay());
    }

    public VideoProcessAppBase(int numAlgFamilies, ImageType<I> imageType) {
        super(numAlgFamilies);
        this.imageType = imageType;
        this.addToToolbar(this.createSelectDelay());
    }

    private JPanel createSelectDelay() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        this.periodSpinner = new JSpinner(new SpinnerNumberModel(this.framePeriod, 0.0, 1000.0, 10.0));
        this.periodSpinner.setMaximumSize(this.periodSpinner.getPreferredSize());
        this.periodSpinner.addChangeListener(this);
        ret.add(new JLabel("Delay"));
        ret.add(this.periodSpinner);
        return ret;
    }

    public void startWorkerThread() {
        new WorkThread().start();
    }

    protected abstract void process(SimpleImageSequence<I> var1);

    protected abstract void updateAlg(I var1, BufferedImage var2);

    protected abstract void updateAlgGUI(I var1, BufferedImage var2, double var3);

    @Override
    public void changeInput(String name, int index) {
        this.stopWorker();
        SimpleImageSequence<I> video = this.media.openVideo(((PathLabel)this.inputRefs.get(index)).getPath(), this.imageType);
        this.process(video);
    }

    protected void stopWorker() {
        this.requestStop = true;
        while (this.isRunning) {
            Thread.yield();
        }
        this.requestStop = false;
    }

    protected abstract void handleRunningStatus(int var1);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isRunning) {
            return;
        }
        this.setPause(!this.isPaused);
    }

    protected void setPause(boolean paused) {
        this.isPaused = paused;
        if (this.isPaused) {
            this.handleRunningStatus(1);
        } else {
            this.handleRunningStatus(0);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.periodSpinner) {
            this.framePeriod = ((Number)this.periodSpinner.getValue()).intValue();
        }
    }

    private class WorkThread
    extends Thread {
        private WorkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VideoProcessAppBase.this.isRunning = true;
            long totalTrackerTime = 0L;
            long totalFrames = 0L;
            VideoProcessAppBase.this.handleRunningStatus(0);
            while (!VideoProcessAppBase.this.requestStop) {
                long startTime = System.currentTimeMillis();
                if (!VideoProcessAppBase.this.isPaused) {
                    if (totalFrames > 20L) {
                        totalFrames = 0L;
                        totalTrackerTime = 0L;
                    }
                    if (!VideoProcessAppBase.this.sequence.hasNext()) break;
                    Object frame = VideoProcessAppBase.this.sequence.next();
                    BufferedImage buffImage = (BufferedImage)VideoProcessAppBase.this.sequence.getGuiImage();
                    long startTracker = System.nanoTime();
                    VideoProcessAppBase.this.updateAlg(frame, buffImage);
                    VideoProcessAppBase.this.updateAlgGUI(frame, buffImage, 1.0E9 / (double)((totalTrackerTime += System.nanoTime() - startTracker) / ++totalFrames));
                    VideoProcessAppBase.this.gui.repaint();
                }
                while (System.currentTimeMillis() - startTime < VideoProcessAppBase.this.framePeriod) {
                    WorkThread workThread = this;
                    synchronized (workThread) {
                        try {
                            long period = System.currentTimeMillis() - startTime - 10L;
                            if (period > 0L) {
                                this.wait(period);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            VideoProcessAppBase.this.isRunning = false;
            VideoProcessAppBase.this.handleRunningStatus(2);
        }
    }
}

