/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.ImageBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListDisplayPanel
extends JPanel
implements ListSelectionListener {
    final List<JPanel> panels = new ArrayList<JPanel>();
    private JPanel bodyPanel;
    private JList listPanel;
    DefaultListModel listModel = new DefaultListModel();
    JScrollPane scroll;
    private int bodyWidth;
    private int bodyHeight;

    public ListDisplayPanel() {
        this.setLayout(new BorderLayout());
        this.listPanel = new JList(this.listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.listPanel);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.scroll, "West");
        this.add(this.bodyPanel);
    }

    public synchronized void reset() {
        this.panels.clear();
        if (SwingUtilities.isEventDispatchThread()) {
            this.listModel.removeAllElements();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListDisplayPanel.this.listModel.removeAllElements();
                }
            });
        }
    }

    public int getListWidth() {
        return (int)this.listPanel.getPreferredSize().getWidth();
    }

    public void addImage(ImageBase image, String name) {
        BufferedImage buff = ConvertBufferedImage.convertTo(image, null, true);
        this.addImage(buff, name, ScaleOptions.DOWN);
    }

    public void addImage(BufferedImage image, String name) {
        this.addImage(image, name, ScaleOptions.DOWN);
    }

    public void addImage(BufferedImage image, String name, ScaleOptions scaling) {
        this.addItem(new ImagePanel(image, scaling), name);
    }

    public synchronized void addItem(JPanel panel, final String name) {
        Dimension panelD = panel.getPreferredSize();
        this.bodyWidth = (int)Math.max((double)this.bodyWidth, panelD.getWidth());
        this.bodyHeight = (int)Math.max((double)this.bodyHeight, panelD.getHeight());
        this.panels.add(panel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListDisplayPanel.this.listModel.addElement(name);
                if (ListDisplayPanel.this.listModel.size() == 1) {
                    ListDisplayPanel.this.listPanel.setSelectedIndex(0);
                }
                Dimension d = ListDisplayPanel.this.listPanel.getMinimumSize();
                ListDisplayPanel.this.listPanel.setPreferredSize(new Dimension(d.width + ListDisplayPanel.this.scroll.getVerticalScrollBar().getWidth(), d.height));
                Component old = ((BorderLayout)ListDisplayPanel.this.bodyPanel.getLayout()).getLayoutComponent("Center");
                if (old != null) {
                    old.setPreferredSize(new Dimension(ListDisplayPanel.this.bodyWidth, ListDisplayPanel.this.bodyHeight));
                }
                ListDisplayPanel.this.validate();
            }
        });
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.listPanel.getSelectedIndex();
        if (index >= 0) {
            this.removeCenterBody();
            JPanel p = this.panels.get(index);
            p.setPreferredSize(new Dimension(this.bodyWidth, this.bodyHeight));
            this.bodyPanel.add((Component)p, "Center");
            this.bodyPanel.validate();
            this.bodyPanel.repaint();
        }
    }

    private void removeCenterBody() {
        Component old = ((BorderLayout)this.bodyPanel.getLayout()).getLayoutComponent("Center");
        if (old != null) {
            this.bodyPanel.remove(old);
        }
    }
}

