/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.VisualizeApp;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.calib.VisualDepthParameters;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class DepthVideoAppBase<I extends ImageGray, Depth extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements VisualizeApp,
MouseListener,
ChangeListener {
    protected VisualDepthParameters config;
    protected SimpleImageSequence<I> sequence1;
    protected SimpleImageSequence<Depth> sequence2;
    volatile boolean requestStop = false;
    volatile boolean isRunning = false;
    volatile boolean isPaused = false;
    long framePeriod = 100L;
    JSpinner periodSpinner;
    protected Class<I> imageType;
    protected Class<Depth> depthType;

    public DepthVideoAppBase(int numAlgFamilies, Class<I> imageType, Class<Depth> depthType) {
        super(numAlgFamilies);
        this.imageType = imageType;
        this.depthType = depthType;
        this.addToToolbar(this.createSelectDelay());
    }

    private JPanel createSelectDelay() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        this.periodSpinner = new JSpinner(new SpinnerNumberModel(this.framePeriod, 0.0, 1000.0, 10.0));
        this.periodSpinner.setMaximumSize(this.periodSpinner.getPreferredSize());
        this.periodSpinner.addChangeListener(this);
        ret.add(new JLabel("Delay"));
        ret.add(this.periodSpinner);
        return ret;
    }

    public void startWorkerThread() {
        new WorkThread().start();
    }

    protected abstract void process(SimpleImageSequence<I> var1, SimpleImageSequence<Depth> var2);

    protected abstract void updateAlg(I var1, BufferedImage var2, Depth var3, BufferedImage var4);

    protected abstract void updateAlgGUI(I var1, BufferedImage var2, Depth var3, BufferedImage var4, double var5);

    @Override
    public void changeInput(String name, int index) {
        this.stopWorker();
        Reader r = this.media.openFile(((PathLabel)this.inputRefs.get(index)).getPath());
        BufferedReader in = new BufferedReader(r);
        try {
            String path = new File(((PathLabel)this.inputRefs.get(index)).getPath()).getParent();
            String lineConfig = in.readLine();
            String line1 = in.readLine();
            String line2 = in.readLine();
            if (lineConfig.charAt(0) != '/') {
                lineConfig = path + "/" + lineConfig;
            }
            if (line1.charAt(0) != '/') {
                line1 = path + "/" + line1;
            }
            if (line2.charAt(0) != '/') {
                line2 = path + "/" + line2;
            }
            this.config = (VisualDepthParameters)UtilIO.loadXML(this.media.openFile(lineConfig));
            SimpleImageSequence<I> video1 = this.media.openVideo(line1, ImageType.single(this.imageType));
            SimpleImageSequence<Depth> video2 = this.media.openVideo(line2, ImageType.single(this.depthType));
            this.process(video1, video2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void stopWorker() {
        this.requestStop = true;
        while (this.isRunning) {
            Thread.yield();
        }
        this.requestStop = false;
    }

    protected abstract void handleRunningStatus(int var1);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isRunning) {
            return;
        }
        boolean bl = this.isPaused = !this.isPaused;
        if (this.isPaused) {
            this.handleRunningStatus(1);
        } else {
            this.handleRunningStatus(0);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.periodSpinner) {
            this.framePeriod = ((Number)this.periodSpinner.getValue()).intValue();
        }
    }

    private class WorkThread
    extends Thread {
        private WorkThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DepthVideoAppBase.this.isRunning = true;
            long totalTrackerTime = 0L;
            long totalFrames = 0L;
            DepthVideoAppBase.this.handleRunningStatus(0);
            while (!DepthVideoAppBase.this.requestStop) {
                long startTime = System.currentTimeMillis();
                if (!DepthVideoAppBase.this.isPaused) {
                    if (totalFrames > 20L) {
                        totalFrames = 0L;
                        totalTrackerTime = 0L;
                    }
                    if (!DepthVideoAppBase.this.sequence1.hasNext() || !DepthVideoAppBase.this.sequence2.hasNext()) break;
                    ImageGray frame1 = (ImageGray)DepthVideoAppBase.this.sequence1.next();
                    ImageGray frame2 = (ImageGray)DepthVideoAppBase.this.sequence2.next();
                    BufferedImage buffImage1 = (BufferedImage)DepthVideoAppBase.this.sequence1.getGuiImage();
                    BufferedImage buffImage2 = (BufferedImage)DepthVideoAppBase.this.sequence2.getGuiImage();
                    long startTracker = System.nanoTime();
                    DepthVideoAppBase.this.updateAlg(frame1, buffImage1, frame2, buffImage2);
                    DepthVideoAppBase.this.updateAlgGUI(frame1, buffImage1, frame2, buffImage2, 1.0E9 / (double)((totalTrackerTime += System.nanoTime() - startTracker) / ++totalFrames));
                    DepthVideoAppBase.this.gui.repaint();
                }
                while (System.currentTimeMillis() - startTime < DepthVideoAppBase.this.framePeriod) {
                    WorkThread workThread = this;
                    synchronized (workThread) {
                        try {
                            long period = System.currentTimeMillis() - startTime - 10L;
                            if (period > 0L) {
                                this.wait(period);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            DepthVideoAppBase.this.isRunning = false;
            DepthVideoAppBase.this.handleRunningStatus(2);
        }
    }
}

