/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperHessianBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperLaplacianBlobIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.detect.intensity.FastCornerIntensity;
import boofcv.alg.feature.detect.intensity.HarrisCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageGray;

public class FactoryIntensityPoint {
    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> fast(int pixelTol, int minCont, Class<I> imageType) {
        FastCornerIntensity<I> alg = FactoryIntensityPointAlg.fast(pixelTol, minCont, imageType);
        return new WrapperFastCornerIntensity(alg);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> harris(int windowRadius, float kappa, boolean weighted, Class<D> derivType) {
        HarrisCornerIntensity<D> alg = FactoryIntensityPointAlg.harris(windowRadius, kappa, weighted, derivType);
        return new WrapperGradientCornerIntensity(alg);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> shiTomasi(int windowRadius, boolean weighted, Class<D> derivType) {
        ShiTomasiCornerIntensity<D> alg = FactoryIntensityPointAlg.shiTomasi(windowRadius, weighted, derivType);
        return new WrapperGradientCornerIntensity(alg);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> kitros(Class<D> derivType) {
        return new WrapperKitRosCornerIntensity(derivType);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> median(int radius, Class<I> imageType) {
        BlurStorageFilter<I> filter = FactoryBlurFilter.median(imageType, radius);
        return new WrapperMedianCornerIntensity(filter, imageType);
    }

    public static <I extends ImageGray, D extends ImageGray> GeneralFeatureIntensity<I, D> hessian(HessianBlobIntensity.Type type, Class<D> derivType) {
        return new WrapperHessianBlobIntensity(type, derivType);
    }

    public static <I extends ImageGray> GeneralFeatureIntensity<I, ?> laplacian() {
        return new WrapperLaplacianBlobIntensity();
    }
}

