/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.tracking;

import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.factory.background.ConfigBackgroundGaussian;
import boofcv.factory.background.FactoryBackgroundModel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import java.awt.image.BufferedImage;

public class ExampleBackgroundRemovalStationary {
    public static void main(String[] args) {
        String fileName = UtilIO.pathExample("background/street_intersection.mp4");
        ImageType<GrayF32> imageType = ImageType.single(GrayF32.class);
        ConfigBackgroundGaussian configGaussian = new ConfigBackgroundGaussian(12.0f, 5.0E-4f);
        configGaussian.initialVariance = 100.0f;
        configGaussian.minimumDifference = 10.0f;
        BackgroundStationaryGaussian<GrayF32> background = FactoryBackgroundModel.stationaryGaussian(configGaussian, imageType);
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        SimpleImageSequence video = media.openVideo(fileName, background.getImageType());
        GrayU8 segmented = new GrayU8(video.getNextWidth(), video.getNextHeight());
        BufferedImage visualized = new BufferedImage(segmented.width, segmented.height, 1);
        ImageGridPanel gui = new ImageGridPanel(1, 2);
        gui.setImages(visualized, visualized);
        ShowImages.showWindow(gui, "Static Scene: Background Segmentation", true);
        double fps = 0.0;
        double alpha = 0.01;
        while (video.hasNext()) {
            Object input = video.next();
            long before = System.nanoTime();
            background.segment((GrayF32)input, segmented);
            background.updateBackground((GrayF32)input);
            long after = System.nanoTime();
            fps = (1.0 - alpha) * fps + alpha * (1.0 / ((double)(after - before) / 1.0E9));
            VisualizeBinaryData.renderBinary(segmented, false, visualized);
            gui.setImage(0, 0, (BufferedImage)video.getGuiImage());
            gui.setImage(0, 1, visualized);
            gui.repaint();
            System.out.println("FPS = " + fps);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("done!");
    }
}

