/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.tracking;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.core.image.GConvertImage;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGaussian;
import boofcv.factory.background.FactoryBackgroundModel;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.homography.UtilHomography;
import java.awt.image.BufferedImage;

public class ExampleBackgroundRemovalMoving {
    public static void main(String[] args) {
        String fileName = UtilIO.pathExample("tracking/chipmunk.mjpeg");
        ImageType<GrayF32> imageType = ImageType.single(GrayF32.class);
        ConfigGeneralDetector confDetector = new ConfigGeneralDetector();
        confDetector.threshold = 10.0f;
        confDetector.maxFeatures = 300;
        confDetector.radius = 6;
        PointTracker<GrayF32> tracker = FactoryPointTracker.klt(new int[]{1, 2, 4, 8}, confDetector, 3, GrayF32.class, null);
        ImageMotion2D<GrayF32, Homography2D_F64> motion2D = FactoryMotion2D.createMotion2D(500, 0.5, 3, 100, 0.6, 0.5, false, tracker, new Homography2D_F64());
        ConfigBackgroundBasic configBasic = new ConfigBackgroundBasic(30.0f, 0.005f);
        ConfigBackgroundGaussian configGaussian = new ConfigBackgroundGaussian(12.0f, 0.001f);
        configGaussian.initialVariance = 64.0f;
        configGaussian.minimumDifference = 5.0f;
        BackgroundMovingBasic<GrayF32, Homography2D_F32> background = FactoryBackgroundModel.movingBasic(configBasic, new PointTransformHomography_F32(), imageType);
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        SimpleImageSequence video = media.openVideo(fileName, background.getImageType());
        GrayU8 segmented = new GrayU8(video.getNextWidth(), video.getNextHeight());
        GrayF32 grey = new GrayF32(segmented.width, segmented.height);
        Homography2D_F32 firstToCurrent32 = new Homography2D_F32();
        Homography2D_F32 homeToWorld = new Homography2D_F32();
        homeToWorld.a13 = grey.width / 2;
        homeToWorld.a23 = grey.height / 2;
        background.initialize(grey.width * 2, grey.height * 2, homeToWorld);
        BufferedImage visualized = new BufferedImage(segmented.width, segmented.height, 1);
        ImageGridPanel gui = new ImageGridPanel(1, 2);
        gui.setImages(visualized, visualized);
        ShowImages.showWindow(gui, "Detections", true);
        double fps = 0.0;
        double alpha = 0.01;
        while (video.hasNext()) {
            Object input = video.next();
            long before = System.nanoTime();
            GConvertImage.convert(input, grey);
            if (!motion2D.process(grey)) {
                throw new RuntimeException("Should handle this scenario");
            }
            Homography2D_F64 firstToCurrent64 = motion2D.getFirstToCurrent();
            UtilHomography.convert((Homography2D_F64)firstToCurrent64, (Homography2D_F32)firstToCurrent32);
            background.segment(firstToCurrent32, (GrayF32)input, segmented);
            background.updateBackground(firstToCurrent32, (GrayF32)input);
            long after = System.nanoTime();
            fps = (1.0 - alpha) * fps + alpha * (1.0 / ((double)(after - before) / 1.0E9));
            VisualizeBinaryData.renderBinary(segmented, false, visualized);
            gui.setImage(0, 0, (BufferedImage)video.getGuiImage());
            gui.setImage(0, 1, visualized);
            gui.repaint();
            System.out.println("FPS = " + fps);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

