/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.stereo;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyFundamental;
import boofcv.core.image.border.BorderType;
import boofcv.examples.stereo.ExampleFundamentalMatrix;
import boofcv.gui.feature.AssociationPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.stereo.RectifiedPairPanel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class ExampleRectifyUncalibratedStereo {
    public static void rectify(DenseMatrix64F F, List<AssociatedPair> inliers, BufferedImage origLeft, BufferedImage origRight) {
        Planar<GrayF32> unrectLeft = ConvertBufferedImage.convertFromMulti(origLeft, null, true, GrayF32.class);
        Planar<GrayF32> unrectRight = ConvertBufferedImage.convertFromMulti(origRight, null, true, GrayF32.class);
        Planar rectLeft = (Planar)unrectLeft.createSameShape();
        Planar rectRight = (Planar)unrectRight.createSameShape();
        RectifyFundamental rectifyAlg = RectifyImageOps.createUncalibrated();
        rectifyAlg.process(F, inliers, origLeft.getWidth(), origLeft.getHeight());
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        RectifyImageOps.fullViewLeft(origLeft.getWidth(), origLeft.getHeight(), rect1, rect2);
        ImageDistort<GrayF32, GrayF32> imageDistortLeft = RectifyImageOps.rectifyImage(rect1, BorderType.SKIP, GrayF32.class);
        ImageDistort<GrayF32, GrayF32> imageDistortRight = RectifyImageOps.rectifyImage(rect2, BorderType.SKIP, GrayF32.class);
        DistortImageOps.distortPL(unrectLeft, rectLeft, imageDistortLeft);
        DistortImageOps.distortPL(unrectRight, rectRight, imageDistortRight);
        BufferedImage outLeft = ConvertBufferedImage.convertTo(rectLeft, null, true);
        BufferedImage outRight = ConvertBufferedImage.convertTo(rectRight, null, true);
        ShowImages.showWindow(new RectifiedPairPanel(true, outLeft, outRight), "Rectified");
    }

    public static void main(String[] args) {
        String dir = UtilIO.pathExample("stereo/");
        BufferedImage imageA = UtilImageIO.loadImage(dir, "mono_wall_01_undist.jpg");
        BufferedImage imageB = UtilImageIO.loadImage(dir, "mono_wall_03_undist.jpg");
        List<AssociatedPair> matches = ExampleFundamentalMatrix.computeMatches(imageA, imageB);
        ArrayList<AssociatedPair> inliers = new ArrayList<AssociatedPair>();
        DenseMatrix64F F = ExampleFundamentalMatrix.robustFundamental(matches, inliers);
        AssociationPanel panel = new AssociationPanel(20);
        panel.setAssociation(inliers);
        panel.setImages(imageA, imageB);
        ShowImages.showWindow(panel, "Inlier Pairs");
        ExampleRectifyUncalibratedStereo.rectify(F, inliers, imageA, imageB);
    }
}

