/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.segmentation;

import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;

public class ExampleThresholding {
    public static void threshold(String imageName) {
        BufferedImage image = UtilImageIO.loadImage(imageName);
        GrayF32 input = ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class);
        GrayU8 binary = new GrayU8(input.width, input.height);
        ListDisplayPanel gui = new ListDisplayPanel();
        GThresholdImageOps.threshold(input, binary, ImageStatistics.mean(input), true);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Global: Mean");
        GThresholdImageOps.threshold(input, binary, GThresholdImageOps.computeOtsu(input, 0, 255), true);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Global: Otsu");
        GThresholdImageOps.threshold(input, binary, GThresholdImageOps.computeEntropy(input, 0, 255), true);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Global: Entropy");
        GThresholdImageOps.localSquare(input, binary, 28, 1.0, true, null, null);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Local: Square");
        GThresholdImageOps.localBlockMinMax(input, binary, 10, 1.0, true, 15.0);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Local: Block Min-Max");
        GThresholdImageOps.localGaussian(input, binary, 42, 1.0, true, null, null);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Local: Gaussian");
        GThresholdImageOps.localSauvola(input, binary, 5, 0.3f, true);
        gui.addImage(VisualizeBinaryData.renderBinary(binary, false, null), "Local: Sauvola");
        gui.addImage(ConvertBufferedImage.convertTo(input, null), "Input Image");
        String fileName = imageName.substring(imageName.lastIndexOf(47) + 1);
        ShowImages.showWindow(gui, fileName);
    }

    public static void main(String[] args) {
        ExampleThresholding.threshold(UtilIO.pathExample("particles01.jpg"));
        ExampleThresholding.threshold(UtilIO.pathExample("segment/uneven_lighting_squares.jpg"));
        ExampleThresholding.threshold(UtilIO.pathExample("segment/stained_handwriting.jpg"));
    }
}

