/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.geometry;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformHomography_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.BorderType;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.transform.homography.HomographyPointOps_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.FastQueue;

public class ExampleImageStitching {
    public static <T extends ImageGray, FD extends TupleDesc> Homography2D_F64 computeTransform(T imageA, T imageB, DetectDescribePoint<T, FD> detDesc, AssociateDescription<FD> associate, ModelMatcher<Homography2D_F64, AssociatedPair> modelMatcher) {
        ArrayList<Point2D_F64> pointsA = new ArrayList<Point2D_F64>();
        FastQueue<FD> descA = UtilFeature.createQueue(detDesc, 100);
        ArrayList<Point2D_F64> pointsB = new ArrayList<Point2D_F64>();
        FastQueue<FD> descB = UtilFeature.createQueue(detDesc, 100);
        ExampleImageStitching.describeImage(imageA, detDesc, pointsA, descA);
        ExampleImageStitching.describeImage(imageB, detDesc, pointsB, descB);
        associate.setSource(descA);
        associate.setDestination(descB);
        associate.associate();
        FastQueue<AssociatedIndex> matches = associate.getMatches();
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < matches.size(); ++i) {
            AssociatedIndex match = (AssociatedIndex)matches.get(i);
            Point2D_F64 a = (Point2D_F64)pointsA.get(match.src);
            Point2D_F64 b = (Point2D_F64)pointsB.get(match.dst);
            pairs.add(new AssociatedPair(a, b, false));
        }
        if (!modelMatcher.process(pairs)) {
            throw new RuntimeException("Model Matcher failed!");
        }
        return ((Homography2D_F64)modelMatcher.getModelParameters()).copy();
    }

    private static <T extends ImageGray, FD extends TupleDesc> void describeImage(T image, DetectDescribePoint<T, FD> detDesc, List<Point2D_F64> points, FastQueue<FD> listDescs) {
        detDesc.detect(image);
        listDescs.reset();
        for (int i = 0; i < detDesc.getNumberOfFeatures(); ++i) {
            points.add(detDesc.getLocation(i).copy());
            ((TupleDesc)listDescs.grow()).setTo(detDesc.getDescription(i));
        }
    }

    public static <T extends ImageGray> void stitch(BufferedImage imageA, BufferedImage imageB, Class<T> imageType) {
        T inputA = ConvertBufferedImage.convertFromSingle(imageA, null, imageType);
        T inputB = ConvertBufferedImage.convertFromSingle(imageB, null, imageType);
        DetectDescribePoint<T, BrightFeature> detDesc = FactoryDetectDescribe.surfStable(new ConfigFastHessian(1.0f, 2, 200, 1, 9, 4, 4), null, null, imageType);
        ScoreAssociation<BrightFeature> scorer = FactoryAssociation.scoreEuclidean(BrightFeature.class, true);
        AssociateDescription<BrightFeature> associate = FactoryAssociation.greedy(scorer, 2.0, true);
        Ransac<Homography2D_F64, AssociatedPair> modelMatcher = FactoryMultiViewRobust.homographyRansac(null, new ConfigRansac(60, 3.0));
        Homography2D_F64 H = ExampleImageStitching.computeTransform(inputA, inputB, detDesc, associate, modelMatcher);
        ExampleImageStitching.renderStitching(imageA, imageB, H);
    }

    public static void renderStitching(BufferedImage imageA, BufferedImage imageB, Homography2D_F64 fromAtoB) {
        double scale = 0.5;
        Planar<GrayF32> colorA = ConvertBufferedImage.convertFromMulti(imageA, null, true, GrayF32.class);
        Planar<GrayF32> colorB = ConvertBufferedImage.convertFromMulti(imageB, null, true, GrayF32.class);
        Planar work = (Planar)colorA.createSameShape();
        Homography2D_F64 fromAToWork = new Homography2D_F64(scale, 0.0, (double)(colorA.width / 4), 0.0, scale, (double)(colorA.height / 4), 0.0, 0.0, 1.0);
        Homography2D_F64 fromWorkToA = fromAToWork.invert(null);
        PixelTransformHomography_F32 model = new PixelTransformHomography_F32();
        InterpolatePixelS<GrayF32> interp = FactoryInterpolation.bilinearPixelS(GrayF32.class, BorderType.ZERO);
        ImageDistort<Planar<GrayF32>, Planar<GrayF32>> distort = DistortSupport.createDistortPL(GrayF32.class, model, interp, false);
        distort.setRenderAll(false);
        model.set(fromWorkToA);
        distort.apply(colorA, work);
        Homography2D_F64 fromWorkToB = fromWorkToA.concat(fromAtoB, null);
        model.set(fromWorkToB);
        distort.apply(colorB, work);
        BufferedImage output = new BufferedImage(work.width, work.height, imageA.getType());
        ConvertBufferedImage.convertTo(work, output, true);
        Graphics2D g2 = output.createGraphics();
        Homography2D_F64 fromBtoWork = fromWorkToB.invert(null);
        Point2D_I32[] corners = new Point2D_I32[]{ExampleImageStitching.renderPoint(0, 0, fromBtoWork), ExampleImageStitching.renderPoint(colorB.width, 0, fromBtoWork), ExampleImageStitching.renderPoint(colorB.width, colorB.height, fromBtoWork), ExampleImageStitching.renderPoint(0, colorB.height, fromBtoWork)};
        g2.setColor(Color.ORANGE);
        g2.setStroke(new BasicStroke(4.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawLine(corners[0].x, corners[0].y, corners[1].x, corners[1].y);
        g2.drawLine(corners[1].x, corners[1].y, corners[2].x, corners[2].y);
        g2.drawLine(corners[2].x, corners[2].y, corners[3].x, corners[3].y);
        g2.drawLine(corners[3].x, corners[3].y, corners[0].x, corners[0].y);
        ShowImages.showWindow(output, "Stitched Images", true);
    }

    private static Point2D_I32 renderPoint(int x0, int y0, Homography2D_F64 fromBtoWork) {
        Point2D_F64 result = new Point2D_F64();
        HomographyPointOps_F64.transform((Homography2D_F64)fromBtoWork, (Point2D_F64)new Point2D_F64((double)x0, (double)y0), (Point2D_F64)result);
        return new Point2D_I32((int)result.x, (int)result.y);
    }

    public static void main(String[] args) {
        BufferedImage imageA = UtilImageIO.loadImage(UtilIO.pathExample("stitch/mountain_rotate_01.jpg"));
        BufferedImage imageB = UtilImageIO.loadImage(UtilIO.pathExample("stitch/mountain_rotate_03.jpg"));
        ExampleImageStitching.stitch(imageA, imageB, GrayF32.class);
        imageA = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_01.jpg"));
        imageB = UtilImageIO.loadImage(UtilIO.pathExample("stitch/kayak_03.jpg"));
        ExampleImageStitching.stitch(imageA, imageB, GrayF32.class);
        imageA = UtilImageIO.loadImage(UtilIO.pathExample("scale/rainforest_01.jpg"));
        imageB = UtilImageIO.loadImage(UtilIO.pathExample("scale/rainforest_02.jpg"));
        ExampleImageStitching.stitch(imageA, imageB, GrayF32.class);
    }
}

